/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class CameraFrame
extends JFrame {
    JPanel cameraPanel = new JPanel();
    JEditorPane cameraEditPane = new JEditorPane();
    JButton dmc = new JButton("Direct Mapped Cache");
    JButton fac = new JButton("Fully Associative Cache");
    JButton sac = new JButton("Set Associative Cache");
    JButton vm = new JButton("Virtual Memory and Paging");
    JButton about = new JButton("About CAMERA");

    public CameraFrame() {
        this.setTitle("CAMERA Workbenches - CS61C Edition v0.0.2");
        this.setDefaultCloseOperation(3);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(CameraFrame.class.getResource("cam.gif")));
        this.cameraEditPane.setContentType("text/html");
        this.cameraEditPane.setText("<body bgcolor = \"aqua\" color = \"blue\" align = \"center\"><h1><i>CAMERA Workbenches</i></h1><h2><i>Cache And Memory Resource Allocation Workbenches</i></h2><h3> Launch CAMERA's cache mapping and virtual memory workbenches by clicking on the buttons below.</h3></body>");
        this.cameraEditPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        this.dmc.setSize(new Dimension(30, 50));
        this.dmc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DMCFrame dMCFrame = new DMCFrame();
                dMCFrame.setSize(1000, 700);
                dMCFrame.setResizable(true);
                dMCFrame.show();
            }
        });
        this.fac.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FACFrame fACFrame = new FACFrame();
                fACFrame.setSize(1000, 700);
                fACFrame.setResizable(true);
                fACFrame.show();
            }
        });
        this.sac.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SACFrame sACFrame = new SACFrame();
                sACFrame.setSize(1000, 700);
                sACFrame.setResizable(true);
                sACFrame.show();
            }
        });
        this.vm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMFrame vMFrame = new VMFrame();
                vMFrame.setSize(1000, 700);
                vMFrame.setResizable(true);
                vMFrame.show();
            }
        });
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CameraFrame.this.showAboutFrame();
            }
        });
        this.cameraPanel.setLayout(new GridLayout(2, 2));
        this.cameraPanel.setPreferredSize(new Dimension(300, 300));
        this.cameraPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        this.cameraPanel.add(this.dmc);
        this.cameraPanel.add(this.fac);
        this.cameraPanel.add(this.sac);
        this.cameraPanel.add(this.vm);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.cameraEditPane, "North");
        container.add((Component)this.cameraPanel, "Center");
        container.add((Component)this.about, "South");
        this.pack();
    }

    public void showAboutFrame() {
        JFrame jFrame = new JFrame("About CAMERA");
        jFrame.setSize(new Dimension(450, 400));
        jFrame.setDefaultCloseOperation(2);
        jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage(DMCFrame.class.getResource("cam.gif")));
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEnabled(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setText("<h1 color = \"blue\" align = \"center\">CAMERA Workbenches</h1><h2 align = \"center\" color = \"blue\">Cache And Memory Resource Allocation Workbenches</h2><h3 align = \"center\">A Master's Project developed under the guidance of Dr. Linda M. Null, Computer Science and Math Department, Penn State Harrisburg.</h3><p align = \"center\">CAMERA is a collection of interactive simulators and workbenches for concepts in memory management such as cache mapping schemes and virtual memory and paging.It was developed as a teaching tool and an enhancement to the book <i>The Essentials of Computer Organization and Architecture</i>, by Dr. Linda M. Null and Julie Lobur.</p><p align = \"center\">Copyright &copy 2003 Karishma Rao</p>");
        jEditorPane.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(jEditorPane);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.show();
    }
}

