/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

class DMCFrame
extends JFrame {
    private CachePanel cachePanel;
    private MemoryPanel memoryPanel;
    private JPanel bottomPanel;
    private JPanel cache;
    private JPanel cacheHitsMisses;
    private JPanel pEastPanel;
    private JPanel pAddRefStr;
    private JPanel pAutoSelfGen;
    private JPanel pBitsInMM1;
    private JPanel pBitsInMM2;
    private JPanel pBitsInMM;
    private JButton restart;
    private JButton next;
    private JButton back;
    private JButton quit;
    private JButton autoGen;
    private JButton selfGen;
    private JLabel lCacheHits;
    private JLabel lCacheMisses;
    private JLabel lProgress;
    private JLabel lBits1;
    private JLabel lBits2;
    private JTextField tCacheHits;
    private JTextField tCacheMisses;
    private JTextField tTag;
    private JTextField tBlock1;
    private JTextField tBlock2;
    private JTextField tWord1;
    private JTextField tWord2;
    private JTextArea tProgress;
    private JScrollPane progressScroll;
    private JScrollPane addRefStrScroll;
    private JList addRefStrList;
    private Border cacheHMBorder;
    private Border bitsInMM1Border;
    private Border bitsInMM2Border;
    private Border bitsInMMBorder;
    private Border addRefStrBorder;
    String[] tempAddress = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String[] addresses = new String[256];
    private Vector listData = new Vector();
    private int moveStatus = 0;
    private int evaluateIndex = 0;
    private int cacheHits;
    private int cacheMisses;
    private String hexAddress = new String();
    private String binAddress = new String();
    private int intBlockDec = 0;
    private int intWordDec = 0;
    private int intBlockDecMem = 0;
    private String tag = new String();
    private String block = new String();
    private String word = new String();
    private String blockMem = new String();
    private String blockDec = new String();
    private String wordDec = new String();
    private boolean reStarted = true;
    private boolean nextClicked = true;

    public DMCFrame() {
        this.setTitle("Direct Mapped Cache");
        this.setDefaultCloseOperation(2);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(DMCFrame.class.getResource("cam.gif")));
        this.restart = new JButton("Restart");
        this.next = new JButton("Next");
        this.back = new JButton("Back");
        this.quit = new JButton("Quit");
        this.lCacheHits = new JLabel("Cache Hits");
        this.lCacheMisses = new JLabel("Cache Misses");
        this.tCacheHits = new JTextField(5);
        this.tCacheMisses = new JTextField(5);
        this.tCacheHits.setEditable(false);
        this.tCacheHits.setFont(new Font("Monospaced", 1, 14));
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setEditable(false);
        this.tCacheMisses.setFont(new Font("Monospaced", 1, 14));
        this.tCacheMisses.setText("  0");
        this.tProgress = new JTextArea(3, 45);
        this.tProgress.setEditable(false);
        this.tProgress.setLineWrap(true);
        this.tProgress.setWrapStyleWord(true);
        this.tProgress.setCaretPosition(0);
        this.tProgress.setFont(new Font("Serif", 3, 16));
        this.tProgress.setText("Welcome to Direct Mapped Cache!\nThe system specs are as follows -\n  16 Blocks in Cache\n  32 Blocks in Main Memory\n  8 Words per Block\nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.progressScroll = new JScrollPane();
        this.progressScroll.getViewport().add(this.tProgress);
        this.progressScroll.setVerticalScrollBarPolicy(22);
        this.lProgress = new JLabel("PROGRESS UPDATE");
        this.addRefStrList = new JList();
        this.addRefStrList.setEnabled(false);
        this.addRefStrScroll = new JScrollPane();
        this.addRefStrScroll.getViewport().setView(this.addRefStrList);
        this.addRefStrScroll.setVerticalScrollBarPolicy(22);
        this.addRefStrScroll.setPreferredSize(new Dimension(140, 300));
        this.autoGen = new JButton("Auto Generate Add. Ref. Str.");
        this.selfGen = new JButton("Self Generate Add. Ref. Str.");
        this.lBits1 = new JLabel("  TAG            BLOCK              WORD");
        this.lBits2 = new JLabel("                 BLOCK                  WORD");
        this.tTag = new JTextField(4);
        this.tTag.setEditable(false);
        this.tBlock1 = new JTextField(5);
        this.tBlock1.setEditable(false);
        this.tBlock2 = new JTextField(8);
        this.tBlock2.setEditable(false);
        this.tWord1 = new JTextField(6);
        this.tWord1.setEditable(false);
        this.tWord2 = new JTextField(6);
        this.tWord2.setEditable(false);
        this.tTag.setFont(new Font("Monospaced", 1, 14));
        this.tBlock1.setFont(new Font("Monospaced", 1, 14));
        this.tWord1.setFont(new Font("Monospaced", 1, 14));
        this.tBlock2.setFont(new Font("Monospaced", 1, 14));
        this.tWord2.setFont(new Font("Monospaced", 1, 14));
        this.restart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMCFrame.this.reStart();
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMCFrame.this.nextClicked = true;
                DMCFrame.this.step();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMCFrame.this.nextClicked = false;
                DMCFrame.this.step();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Really Quit?", "Quit Confirmation", 0, 3);
                switch (n) {
                    case 0: {
                        DMCFrame.this.removeInstance();
                    }
                }
            }
        });
        this.autoGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMCFrame.this.autoGenerateString();
            }
        });
        this.selfGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DMCFrame.this.selfGenerateString();
            }
        });
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.cachePanel = new CachePanel();
        this.memoryPanel = new MemoryPanel();
        this.bottomPanel = new JPanel();
        this.cache = new JPanel();
        this.cacheHitsMisses = new JPanel();
        this.pAutoSelfGen = new JPanel();
        this.pAddRefStr = new JPanel();
        this.pEastPanel = new JPanel();
        this.pBitsInMM = new JPanel();
        this.pBitsInMM1 = new JPanel();
        this.pBitsInMM2 = new JPanel();
        this.bottomPanel.add(this.lProgress);
        this.bottomPanel.add(this.progressScroll);
        this.bottomPanel.add(this.restart);
        this.bottomPanel.add(this.next);
        this.bottomPanel.add(this.back);
        this.bottomPanel.add(this.quit);
        this.cacheHitsMisses.add(this.lCacheHits);
        this.cacheHitsMisses.add(this.tCacheHits);
        this.cacheHitsMisses.add(this.lCacheMisses);
        this.cacheHitsMisses.add(this.tCacheMisses);
        this.cacheHMBorder = BorderFactory.createEtchedBorder();
        this.cacheHitsMisses.setBorder(BorderFactory.createTitledBorder(this.cacheHMBorder, ""));
        this.cache.setLayout(new BorderLayout());
        this.cache.add((Component)this.cachePanel, "Center");
        this.cache.add((Component)this.cacheHitsMisses, "South");
        this.pAutoSelfGen.setLayout(new GridLayout(2, 1));
        this.pAutoSelfGen.add(this.autoGen);
        this.pAutoSelfGen.add(this.selfGen);
        this.pAddRefStr.setLayout(new BorderLayout());
        this.pAddRefStr.setPreferredSize(new Dimension(160, 400));
        this.pAddRefStr.add((Component)this.addRefStrScroll, "Center");
        this.pAddRefStr.add((Component)this.pAutoSelfGen, "South");
        this.addRefStrBorder = BorderFactory.createEtchedBorder();
        this.pAddRefStr.setBorder(BorderFactory.createTitledBorder(this.addRefStrBorder, " Address Reference String "));
        this.pBitsInMM1.setLayout(new BorderLayout());
        this.bitsInMM1Border = BorderFactory.createEtchedBorder();
        this.pBitsInMM1.setBorder(BorderFactory.createTitledBorder(this.bitsInMM1Border, " Main Memory Address "));
        this.pBitsInMM1.add((Component)this.tTag, "West");
        this.pBitsInMM1.add((Component)this.tBlock1, "Center");
        this.pBitsInMM1.add((Component)this.tWord1, "East");
        this.pBitsInMM1.add((Component)this.lBits1, "South");
        this.pBitsInMM2.setLayout(new BorderLayout());
        this.bitsInMM2Border = BorderFactory.createEtchedBorder();
        this.pBitsInMM2.setBorder(BorderFactory.createTitledBorder(this.bitsInMM2Border, " Memory Block and Word Bits "));
        this.pBitsInMM2.add((Component)this.tBlock2, "Center");
        this.pBitsInMM2.add((Component)this.tWord2, "East");
        this.pBitsInMM2.add((Component)this.lBits2, "South");
        this.pBitsInMM.setLayout(new GridLayout(2, 1));
        this.bitsInMMBorder = BorderFactory.createEtchedBorder();
        this.pBitsInMM.setBorder(BorderFactory.createTitledBorder(this.bitsInMMBorder, ""));
        this.pBitsInMM.add(this.pBitsInMM1);
        this.pBitsInMM.add(this.pBitsInMM2);
        this.pEastPanel.setLayout(new BorderLayout());
        this.pEastPanel.setPreferredSize(new Dimension(210, 600));
        this.pEastPanel.add((Component)this.pAddRefStr, "Center");
        this.pEastPanel.add((Component)this.pBitsInMM, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.cache, "West");
        container.add((Component)this.memoryPanel, "Center");
        container.add((Component)this.pEastPanel, "East");
        container.add((Component)this.bottomPanel, "South");
        this.createAddresses();
        this.pack();
    }

    public void reStart() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.cachePanel.boolBlocks[n] = false;
            this.cachePanel.stringBlocks[n] = "";
            this.cachePanel.tag[n] = "";
        }
        for (n = 0; n < 8; ++n) {
            this.cachePanel.boolWords[n] = false;
            this.memoryPanel.boolWords[n] = false;
        }
        for (n = 0; n < 32; ++n) {
            this.memoryPanel.boolBlocks[n] = false;
        }
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setText("  0");
        this.listData.removeAllElements();
        this.addRefStrList.setListData(this.listData);
        this.tTag.setText("");
        this.tBlock1.setText("");
        this.tBlock2.setText("");
        this.tWord1.setText("");
        this.tWord2.setText("");
        this.tTag.setBackground(new Color(205, 205, 205));
        this.tBlock1.setBackground(new Color(205, 205, 205));
        this.tWord1.setBackground(new Color(205, 205, 205));
        this.tBlock2.setBackground(new Color(205, 205, 205));
        this.tWord2.setBackground(new Color(205, 205, 205));
        this.tProgress.setText("Let's start over.\nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.autoGen.setEnabled(true);
        this.selfGen.setEnabled(true);
        this.moveStatus = 0;
        this.evaluateIndex = 0;
        this.reStarted = true;
        this.repaint();
    }

    public void step() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.cachePanel.boolBlocks[n] = false;
            this.cachePanel.stringBlocks[n] = "";
            this.cachePanel.tag[n] = "";
        }
        for (n = 0; n < 8; ++n) {
            this.cachePanel.boolWords[n] = false;
            this.memoryPanel.boolWords[n] = false;
        }
        for (n = 0; n < 32; ++n) {
            this.memoryPanel.boolBlocks[n] = false;
        }
        this.tTag.setText("");
        this.tBlock1.setText("");
        this.tBlock2.setText("");
        this.tWord1.setText("");
        this.tWord2.setText("");
        this.tTag.setBackground(new Color(205, 205, 205));
        this.tBlock1.setBackground(new Color(205, 205, 205));
        this.tWord1.setBackground(new Color(205, 205, 205));
        this.tBlock2.setBackground(new Color(205, 205, 205));
        this.tWord2.setBackground(new Color(205, 205, 205));
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.tCacheHits.setText("  " + this.cacheHits);
        this.tCacheMisses.setText("  " + this.cacheMisses);
        this.evaluateIndex = 0;
        this.autoGen.setEnabled(false);
        this.selfGen.setEnabled(false);
        if (this.nextClicked) {
            ++this.moveStatus;
        } else {
            --this.moveStatus;
            this.next.setEnabled(true);
        }
        if (this.moveStatus == 0) {
            this.back.setEnabled(false);
            this.tProgress.setText("You cannot go back any further.\nPlease click on \"Next\" or \"Restart\" to continue.");
            this.tProgress.setCaretPosition(0);
            this.addRefStrList.clearSelection();
        } else {
            this.back.setEnabled(true);
        }
        block11: for (n = 1; n <= this.moveStatus; ++n) {
            switch (n % 6) {
                case 1: {
                    this.addRefStrList.setSelectedIndex(this.evaluateIndex);
                    if (n == this.moveStatus) {
                        this.addRefStrList.ensureIndexIsVisible(this.evaluateIndex);
                    }
                    this.hexAddress = (String)this.addRefStrList.getSelectedValue();
                    int n2 = Integer.parseInt(this.hexAddress, 16);
                    this.binAddress = Integer.toBinaryString(n2);
                    if (this.binAddress.length() < 8) {
                        int n3 = 8 - this.binAddress.length();
                        for (int i = 0; i < n3; ++i) {
                            this.binAddress = '0' + this.binAddress;
                        }
                    }
                    this.tag = this.binAddress.substring(0, 1);
                    this.block = this.binAddress.substring(1, 5);
                    this.word = this.binAddress.substring(5);
                    this.blockMem = this.binAddress.substring(0, 5);
                    this.intBlockDec = Integer.parseInt(this.block, 2);
                    this.intWordDec = Integer.parseInt(this.word, 2);
                    this.intBlockDecMem = Integer.parseInt(this.blockMem, 2);
                    if (n != this.moveStatus) continue block11;
                    this.tProgress.setText("The memory address we want is obtained from the Address Reference String.\nIt is (in hexadecimal): " + this.hexAddress + ".");
                    this.tProgress.setCaretPosition(0);
                    continue block11;
                }
                case 2: {
                    if (n == this.moveStatus) {
                        this.tProgress.setText("The hexadecimal address " + this.hexAddress + " evaluates to its binary equivalent " + this.binAddress + "." + "\nHence the bits in the Main Memory Address are divided into the following fields\n" + this.tag + " --> Tag,  " + this.block + " --> Block,  " + this.word + " --> Word." + "\nThe above field values are used to access the required cache block." + "\n\nFrom the 8 bit binary address, " + this.binAddress + ", evaluated above " + "we can also retrieve the following data:" + "\nThe leftmost 5 bits, " + this.tag + this.block + ", and the rightmost 3 bits, " + this.word + ", indicate the actual memory block and word in question, respectively.");
                        this.tProgress.setCaretPosition(0);
                        this.tTag.setBackground(Color.green);
                        this.tBlock1.setBackground(Color.green);
                        this.tWord1.setBackground(Color.green);
                        this.tBlock2.setBackground(Color.green);
                        this.tWord2.setBackground(Color.green);
                    }
                    this.tTag.setText(" " + this.tag);
                    this.tBlock1.setText("    " + this.block);
                    this.tWord1.setText(" " + this.word);
                    this.tBlock2.setText("      " + this.tag + this.block);
                    this.tWord2.setText(" " + this.word);
                    continue block11;
                }
                case 3: {
                    this.tTag.setBackground(new Color(205, 205, 205));
                    this.tBlock1.setBackground(new Color(205, 205, 205));
                    this.tWord1.setBackground(new Color(205, 205, 205));
                    this.tBlock2.setBackground(new Color(205, 205, 205));
                    this.tWord2.setBackground(new Color(205, 205, 205));
                    if (n == this.moveStatus) {
                        this.tProgress.setText("The bits in the Main Memory Address indicating the cache block are " + this.block + ".\nThe equivalent block number in decimal is " + this.intBlockDec + ", so the block " + this.intBlockDec + " is searched in the cache.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.cachePanel.boolBlocks[this.intBlockDec] = true;
                    if (this.cachePanel.stringBlocks[this.intBlockDec].equals("")) {
                        ++this.cacheMisses;
                        this.tCacheMisses.setText("  " + this.cacheMisses);
                        if (n != this.moveStatus) continue block11;
                        this.tProgress.append("\nSince the required cache block is empty, there is a cache miss.");
                        this.tProgress.setCaretPosition(0);
                        continue block11;
                    }
                    if (this.cachePanel.stringBlocks[this.intBlockDec].equals("" + this.intBlockDecMem)) {
                        ++this.cacheHits;
                        this.tCacheHits.setText("  " + this.cacheHits);
                        if (n != this.moveStatus) continue block11;
                        this.tProgress.append("\nSince the required cache block contains the memory block, there is a cache hit.");
                        this.tProgress.setCaretPosition(0);
                        continue block11;
                    }
                    ++this.cacheMisses;
                    this.tCacheMisses.setText("  " + this.cacheMisses);
                    if (n != this.moveStatus) continue block11;
                    this.tProgress.append("\nSince the required cache block does not contain the memory block, there is a cache miss.");
                    this.tProgress.setCaretPosition(0);
                    continue block11;
                }
                case 4: {
                    this.cachePanel.boolBlocks[this.intBlockDec] = false;
                    if (this.cachePanel.stringBlocks[this.intBlockDec].equals("")) {
                        if (n == this.moveStatus) {
                            this.tProgress.setText("Since the 5 leftmost bits are " + this.tag + this.block + ", the memory block we need (in decimal) is " + this.intBlockDecMem + "." + "\nAs we saw in the previous step, the required block of the cache is empty " + "so we need to bring in the block from memory.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.memoryPanel.boolBlocks[this.intBlockDecMem] = true;
                        this.memoryPanel.boolWords[this.intWordDec] = true;
                        continue block11;
                    }
                    if (this.cachePanel.stringBlocks[this.intBlockDec].equals("" + this.intBlockDecMem)) {
                        if (n == this.moveStatus) {
                            this.tProgress.setText("Since the 5 leftmost bits are " + this.tag + this.block + ", the memory block we need (in decimal) is " + this.intBlockDecMem + "." + "\nAs saw in the previous step, " + "the block of the cache already contains this required block " + "so we can now access it from cache as needed.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.memoryPanel.boolBlocks[this.intBlockDecMem] = true;
                        this.memoryPanel.boolWords[this.intWordDec] = true;
                        continue block11;
                    }
                    if (n == this.moveStatus) {
                        this.tProgress.setText("Since the 5 leftmost bits are " + this.tag + this.block + ", the memory block we need (in decimal) is " + this.intBlockDecMem + "." + "\nAs we saw in the previous step, the required block of the cache is filled, " + "but with another memory block." + "\nSo we need to bring in the block from memory and " + "replace the existing cache block.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.memoryPanel.boolBlocks[this.intBlockDecMem] = true;
                    this.memoryPanel.boolWords[this.intWordDec] = true;
                    continue block11;
                }
                case 5: {
                    this.memoryPanel.boolBlocks[this.intBlockDecMem] = false;
                    this.memoryPanel.boolWords[this.intWordDec] = false;
                    this.cachePanel.stringBlocks[this.intBlockDec] = "" + this.intBlockDecMem;
                    this.cachePanel.tag[this.intBlockDec] = this.tag;
                    if (n == this.moveStatus) {
                        this.tProgress.setText("Now that the required memory block is in cache we note the following 3 things:\n1. The cache block has a tag associated with it and the tag, as specified by the Tag bit in the Main Memory Address, has a value of " + this.tag + ".\n2. The word bits, as specified in the Main Memory Address, are " + this.word + " which indicate the word at offset " + this.wordDec + " in the block." + "\n3.If the cache was originally empty or contained a memory block other than the one" + " we required, the count of Cache Misses was incremented." + "\nIf the cache already had the required memory block in it, " + "then the count of Cache Hits was incremented.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.cachePanel.boolBlocks[this.intBlockDec] = true;
                    this.cachePanel.boolWords[this.intWordDec] = true;
                    this.cachePanel.boolTags[this.intBlockDec] = true;
                    continue block11;
                }
                case 0: {
                    this.cachePanel.boolBlocks[this.intBlockDec] = false;
                    this.cachePanel.boolWords[this.intWordDec] = false;
                    this.cachePanel.boolTags[this.intBlockDec] = false;
                    this.tTag.setText("");
                    this.tBlock1.setText("");
                    this.tWord1.setText("");
                    this.tBlock2.setText("");
                    this.tWord2.setText("");
                    this.tTag.setBackground(new Color(205, 205, 205));
                    this.tBlock1.setBackground(new Color(205, 205, 205));
                    this.tWord1.setBackground(new Color(205, 205, 205));
                    this.tBlock2.setBackground(new Color(205, 205, 205));
                    this.tWord2.setBackground(new Color(205, 205, 205));
                    this.addRefStrList.clearSelection();
                    ++this.evaluateIndex;
                    if (this.evaluateIndex == this.listData.size()) {
                        if (n == this.moveStatus) {
                            this.tProgress.setText("This completes the runthrough.\nPlease click on \"Restart\", generate the Address Reference String OR click \"Quit\" to finish.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.next.setEnabled(false);
                        this.autoGen.setEnabled(true);
                        this.selfGen.setEnabled(true);
                        this.reStarted = false;
                        continue block11;
                    }
                    if (n == this.moveStatus) {
                        this.tProgress.setText("This completes an access cycle.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.addRefStrList.clearSelection();
                    continue block11;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Uh Oh, there's a problem in switch-case!");
                }
            }
        }
        this.repaint();
    }

    public void createAddresses() {
        int n = -1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.addresses[++n] = this.tempAddress[i] + this.tempAddress[j];
            }
        }
    }

    public void autoGenerateString() {
        for (int i = 0; i < 10; ++i) {
            int n = (int)(Math.random() * 256.0);
            this.listData.add(this.addresses[n]);
        }
        this.addRefStrList.setListData(this.listData);
        this.next.setEnabled(true);
        this.back.setEnabled(false);
        this.tProgress.setText("We have automatically generated an address string of 10 addresses for you to work with.\nClick on \"Next\" to continue.");
    }

    public void selfGenerateString() {
        int n = 0;
        int n2 = 0;
        JTextField jTextField = new JTextField();
        Object[] objectArray = new Object[]{"Enter String", jTextField};
        Object[] objectArray2 = new Object[]{"Continue", "Done"};
        while (n == 0 && n2 < 10) {
            n = JOptionPane.showOptionDialog(this, objectArray, "Self Generate", 0, 3, null, objectArray2, objectArray2[0]);
            if (n == 0) {
                if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                    ++n2;
                    this.listData.add(jTextField.getText().toUpperCase());
                } else {
                    JOptionPane.showMessageDialog(this, "Invalid Input. Please try again.", "Invalid Input", 0);
                }
                jTextField.setText("");
                continue;
            }
            if (n != 1 || jTextField.getText().equals("")) continue;
            if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                this.listData.add(jTextField.getText().toUpperCase());
                this.tProgress.setText("You have generated an Address Reference String of " + ++n2 + " address." + "\nPlease click on \"Next\" to continue.");
                this.tProgress.setCaretPosition(0);
                continue;
            }
            JOptionPane.showMessageDialog(this, "Invalid Input. Quitting without saving last entry.", "Invalid Input", 0);
            this.tProgress.setText("You have generated an Address Reference String of " + n2 + " address." + "\nPlease click on \"Next\" to continue.");
            this.tProgress.setCaretPosition(0);
        }
        this.addRefStrList.setListData(this.listData);
        if (n2 > 0) {
            this.next.setEnabled(true);
            this.back.setEnabled(false);
        }
    }

    public boolean validateInput(String string) {
        for (int i = 0; i < 256; ++i) {
            if (!this.addresses[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void removeInstance() {
        this.dispose();
    }
}

