/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

class FACFrame
extends JFrame {
    private FACachePanel cachePanel;
    private MemoryPanel memoryPanel;
    private JPanel bottomPanel;
    private JPanel cache;
    private JPanel cacheHitsMisses;
    private JPanel pEastPanel;
    private JPanel pAddRefStr;
    private JPanel pAutoSelfGen;
    private JPanel pBitsInMM;
    private JButton restart;
    private JButton next;
    private JButton back;
    private JButton quit;
    private JButton autoGen;
    private JButton selfGen;
    private JLabel lCacheHits;
    private JLabel lCacheMisses;
    private JLabel lProgress;
    private JLabel lBits;
    private JTextField tCacheHits;
    private JTextField tCacheMisses;
    private JTextField tTag;
    private JTextField tWord;
    private JTextArea tProgress;
    private JScrollPane progressScroll;
    private JScrollPane addRefStrScroll;
    private JList addRefStrList;
    private Border cacheHMBorder;
    private Border bitsInMMBorder;
    private Border addRefStrBorder;
    String[] tempAddress = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String[] addresses = new String[256];
    private Vector listData = new Vector();
    private int moveStatus = 0;
    private int evaluateIndex = 0;
    private int cacheHits;
    private int cacheMisses;
    private int statusLRU = 0;
    private int[] statusCacheLRU = new int[16];
    private boolean[] statusCacheEmpty = new boolean[16];
    private int memInCache = -1;
    int emptyCacheBlock = -1;
    int lruCacheBlock = -1;
    private String hexAddress = new String();
    private String binAddress = new String();
    private int intBlockDec = 0;
    private int intWordDec = 0;
    private int intBlockDecMem = 0;
    private String tag = new String();
    private String word = new String();
    private String blockMem = new String();
    private String blockDec = new String();
    private String wordDec = new String();
    private boolean reStarted = true;
    private boolean nextClicked = true;

    public FACFrame() {
        this.setTitle("Fully Associative Cache");
        this.setDefaultCloseOperation(2);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(FACFrame.class.getResource("cam.gif")));
        this.restart = new JButton("Restart");
        this.next = new JButton("Next");
        this.back = new JButton("Back");
        this.quit = new JButton("Quit");
        this.lCacheHits = new JLabel("Cache Hits");
        this.lCacheMisses = new JLabel("Cache Misses");
        this.tCacheHits = new JTextField(5);
        this.tCacheMisses = new JTextField(5);
        this.tCacheHits.setEditable(false);
        this.tCacheHits.setFont(new Font("Monospaced", 1, 14));
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setEditable(false);
        this.tCacheMisses.setFont(new Font("Monospaced", 1, 14));
        this.tCacheMisses.setText("  0");
        this.tProgress = new JTextArea(3, 45);
        this.tProgress.setEditable(false);
        this.tProgress.setLineWrap(true);
        this.tProgress.setWrapStyleWord(true);
        this.tProgress.setCaretPosition(0);
        this.tProgress.setFont(new Font("Serif", 3, 16));
        this.tProgress.setText("Welcome to Fully Associative Cache!\nThe system specs are as follows -\n  16 Blocks in Cache\n  32 Blocks in Main Memory\n  8 Words per Block\n  The replacement algorithm shown is the Least-Recently-Used algorithm\n  as it is the most commonly used one.\nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.progressScroll = new JScrollPane();
        this.progressScroll.getViewport().add(this.tProgress);
        this.progressScroll.setVerticalScrollBarPolicy(22);
        this.lProgress = new JLabel("PROGRESS UPDATE");
        this.addRefStrList = new JList();
        this.addRefStrList.setEnabled(false);
        this.addRefStrScroll = new JScrollPane();
        this.addRefStrScroll.getViewport().setView(this.addRefStrList);
        this.addRefStrScroll.setVerticalScrollBarPolicy(22);
        this.addRefStrScroll.setPreferredSize(new Dimension(140, 300));
        this.autoGen = new JButton("Auto Generate Add. Ref. Str.");
        this.selfGen = new JButton("Self Generate Add. Ref. Str.");
        this.lBits = new JLabel("                   TAG                        WORD");
        this.tTag = new JTextField(9);
        this.tTag.setEditable(false);
        this.tWord = new JTextField(7);
        this.tWord.setEditable(false);
        this.tTag.setFont(new Font("Monospaced", 1, 14));
        this.tWord.setFont(new Font("Monospaced", 1, 14));
        this.restart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FACFrame.this.reStart();
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FACFrame.this.nextClicked = true;
                FACFrame.this.step();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FACFrame.this.nextClicked = false;
                FACFrame.this.step();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Really Quit?", "Quit Confirmation", 0, 3);
                switch (n) {
                    case 0: {
                        FACFrame.this.removeInstance();
                    }
                }
            }
        });
        this.autoGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FACFrame.this.autoGenerateString();
            }
        });
        this.selfGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FACFrame.this.selfGenerateString();
            }
        });
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.cachePanel = new FACachePanel();
        this.memoryPanel = new MemoryPanel();
        this.bottomPanel = new JPanel();
        this.cache = new JPanel();
        this.cacheHitsMisses = new JPanel();
        this.pAutoSelfGen = new JPanel();
        this.pAddRefStr = new JPanel();
        this.pEastPanel = new JPanel();
        this.pBitsInMM = new JPanel();
        this.bottomPanel.add(this.lProgress);
        this.bottomPanel.add(this.progressScroll);
        this.bottomPanel.add(this.restart);
        this.bottomPanel.add(this.next);
        this.bottomPanel.add(this.back);
        this.bottomPanel.add(this.quit);
        this.cacheHitsMisses.add(this.lCacheHits);
        this.cacheHitsMisses.add(this.tCacheHits);
        this.cacheHitsMisses.add(this.lCacheMisses);
        this.cacheHitsMisses.add(this.tCacheMisses);
        this.cacheHMBorder = BorderFactory.createEtchedBorder();
        this.cacheHitsMisses.setBorder(BorderFactory.createTitledBorder(this.cacheHMBorder, ""));
        this.cache.setLayout(new BorderLayout());
        this.cache.add((Component)this.cachePanel, "Center");
        this.cache.add((Component)this.cacheHitsMisses, "South");
        this.pAutoSelfGen.setLayout(new GridLayout(2, 1));
        this.pAutoSelfGen.add(this.autoGen);
        this.pAutoSelfGen.add(this.selfGen);
        this.pAddRefStr.setLayout(new BorderLayout());
        this.pAddRefStr.setPreferredSize(new Dimension(160, 400));
        this.pAddRefStr.add((Component)this.addRefStrScroll, "Center");
        this.pAddRefStr.add((Component)this.pAutoSelfGen, "South");
        this.addRefStrBorder = BorderFactory.createEtchedBorder();
        this.pAddRefStr.setBorder(BorderFactory.createTitledBorder(this.addRefStrBorder, " Address Reference String "));
        this.pBitsInMM.setLayout(new BorderLayout());
        this.bitsInMMBorder = BorderFactory.createEtchedBorder();
        this.pBitsInMM.setBorder(BorderFactory.createTitledBorder(this.bitsInMMBorder, " Main Memory Address "));
        this.pBitsInMM.add((Component)this.tTag, "Center");
        this.pBitsInMM.add((Component)this.tWord, "East");
        this.pBitsInMM.add((Component)this.lBits, "South");
        this.pEastPanel.setLayout(new BorderLayout());
        this.pEastPanel.setPreferredSize(new Dimension(210, 600));
        this.pEastPanel.add((Component)this.pAddRefStr, "Center");
        this.pEastPanel.add((Component)this.pBitsInMM, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.cache, "West");
        container.add((Component)this.memoryPanel, "Center");
        container.add((Component)this.pEastPanel, "East");
        container.add((Component)this.bottomPanel, "South");
        for (int i = 0; i < 16; ++i) {
            this.statusCacheEmpty[i] = true;
            this.statusCacheLRU[i] = 0;
        }
        this.createAddresses();
        this.pack();
    }

    public void reStart() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.cachePanel.stringBlocks[n] = "";
            this.cachePanel.boolBlocks[n] = false;
            this.cachePanel.tag[n] = "";
            this.cachePanel.boolTags[n] = false;
            this.statusCacheEmpty[n] = true;
            this.statusCacheLRU[n] = 0;
        }
        for (n = 0; n < 8; ++n) {
            this.cachePanel.boolWords[n] = false;
            this.memoryPanel.boolWords[n] = false;
        }
        for (n = 0; n < 32; ++n) {
            this.memoryPanel.boolBlocks[n] = false;
        }
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setText("  0");
        this.statusLRU = 0;
        this.memInCache = -1;
        this.lruCacheBlock = -1;
        this.listData.removeAllElements();
        this.addRefStrList.setListData(this.listData);
        this.tTag.setText("");
        this.tWord.setText("");
        this.tTag.setBackground(new Color(205, 205, 205));
        this.tWord.setBackground(new Color(205, 205, 205));
        this.tProgress.setText("Let's start over. \nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.autoGen.setEnabled(true);
        this.selfGen.setEnabled(true);
        this.moveStatus = 0;
        this.evaluateIndex = 0;
        this.reStarted = true;
        this.repaint();
    }

    public void step() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.cachePanel.stringBlocks[n] = "";
            this.cachePanel.boolBlocks[n] = false;
            this.cachePanel.tag[n] = "";
            this.cachePanel.boolTags[n] = false;
            this.statusCacheEmpty[n] = true;
            this.statusCacheLRU[n] = 0;
        }
        for (n = 0; n < 8; ++n) {
            this.cachePanel.boolWords[n] = false;
            this.memoryPanel.boolWords[n] = false;
        }
        for (n = 0; n < 32; ++n) {
            this.memoryPanel.boolBlocks[n] = false;
        }
        this.tTag.setText("");
        this.tWord.setText("");
        this.tTag.setBackground(new Color(205, 205, 205));
        this.tWord.setBackground(new Color(205, 205, 205));
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setText("  0");
        this.statusLRU = 0;
        this.memInCache = -1;
        this.lruCacheBlock = -1;
        this.evaluateIndex = 0;
        this.autoGen.setEnabled(false);
        this.selfGen.setEnabled(false);
        if (this.nextClicked) {
            ++this.moveStatus;
        } else {
            --this.moveStatus;
            this.next.setEnabled(true);
        }
        if (this.moveStatus == 0) {
            this.back.setEnabled(false);
            this.tProgress.setText("You cannot go back any further.\nPlease click on \"Next\" or \"Restart\" to continue.");
            this.tProgress.setCaretPosition(0);
            this.addRefStrList.clearSelection();
        } else {
            this.back.setEnabled(true);
        }
        block11: for (n = 1; n <= this.moveStatus; ++n) {
            switch (n % 6) {
                case 1: {
                    this.addRefStrList.setSelectedIndex(this.evaluateIndex);
                    if (n == this.moveStatus) {
                        this.addRefStrList.ensureIndexIsVisible(this.evaluateIndex);
                    }
                    this.hexAddress = (String)this.addRefStrList.getSelectedValue();
                    int n2 = Integer.parseInt(this.hexAddress, 16);
                    this.binAddress = Integer.toBinaryString(n2);
                    if (this.binAddress.length() < 8) {
                        int n3 = 8 - this.binAddress.length();
                        for (int i = 0; i < n3; ++i) {
                            this.binAddress = '0' + this.binAddress;
                        }
                    }
                    this.tag = this.binAddress.substring(0, 5);
                    this.word = this.binAddress.substring(5);
                    this.intWordDec = Integer.parseInt(this.word, 2);
                    this.intBlockDecMem = Integer.parseInt(this.tag, 2);
                    if (n != this.moveStatus) continue block11;
                    this.tProgress.setText("The memory address we want is obtained from the Address Reference String.\nIt is (in hexadecimal): " + this.hexAddress + ".");
                    this.tProgress.setCaretPosition(0);
                    continue block11;
                }
                case 2: {
                    if (n == this.moveStatus) {
                        this.tProgress.setText("The hexadecimal address " + this.hexAddress + " evaluates to its binary equivalent " + this.binAddress + "." + "\nHence the bits in the Main Memory Address are divided into the following fields\n" + this.tag + " --> Tag,  " + this.word + " --> Word." + "\nThe tag bits identify the memory block, " + "and the word bits identify the word within the block.");
                        this.tProgress.setCaretPosition(0);
                        this.tTag.setBackground(Color.green);
                        this.tWord.setBackground(Color.green);
                    }
                    this.tTag.setText("      " + this.tag);
                    this.tWord.setText("  " + this.word);
                    continue block11;
                }
                case 3: {
                    this.tTag.setBackground(new Color(205, 205, 205));
                    this.tWord.setBackground(new Color(205, 205, 205));
                    if (n == this.moveStatus) {
                        this.tProgress.setText("Every time a memory block is placed in cache, its tag field is stored with it as well.\nSo, to find the required memory block in cache, its tag, " + this.tag + " is compared to all the valid tag fields in cache.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.memInCache = this.getCacheBlock(this.tag);
                    if (this.memInCache == -1) {
                        if (n == this.moveStatus) {
                            this.tProgress.append("\n\nSince the memory block is not in cache, there is a cache miss.\nSo the block needs to be brought in from memory.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.emptyCacheBlock = this.getFirstEmptyCacheBlock();
                        if (this.emptyCacheBlock != -1) {
                            if (n == this.moveStatus) {
                                this.tProgress.append("\nSince the cache has empty space, the first available block will be filled.\nSee the highlighted cache block.");
                                this.tProgress.setCaretPosition(0);
                            }
                            this.cachePanel.boolBlocks[this.emptyCacheBlock] = true;
                            this.cachePanel.boolTags[this.emptyCacheBlock] = true;
                            this.intBlockDec = this.emptyCacheBlock;
                        } else {
                            if (n == this.moveStatus) {
                                this.tProgress.append("\nSince the cache is full, the least recently used cache block will be replaced.\nSee the highlighted cache block.");
                                this.tProgress.setCaretPosition(0);
                            }
                            this.lruCacheBlock = this.getLRUCacheBlock();
                            this.cachePanel.boolBlocks[this.lruCacheBlock] = true;
                            this.cachePanel.boolTags[this.lruCacheBlock] = true;
                            this.intBlockDec = this.lruCacheBlock;
                        }
                        ++this.cacheMisses;
                        this.tCacheMisses.setText("  " + this.cacheMisses);
                        continue block11;
                    }
                    if (n == this.moveStatus) {
                        this.tProgress.append("\n\nSince the required memory block is in cache block " + this.memInCache + " there is a cache hit.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.cachePanel.boolBlocks[this.memInCache] = true;
                    this.cachePanel.boolWords[this.intWordDec] = true;
                    this.cachePanel.boolTags[this.memInCache] = true;
                    this.intBlockDec = this.memInCache;
                    ++this.cacheHits;
                    this.tCacheHits.setText("  " + this.cacheHits);
                    continue block11;
                }
                case 4: {
                    this.cachePanel.boolBlocks[this.intBlockDec] = false;
                    this.cachePanel.boolWords[this.intWordDec] = false;
                    this.cachePanel.boolTags[this.intBlockDec] = false;
                    if (n == this.moveStatus) {
                        this.tProgress.setText("Highlighted is the memory block in question. Since the tag bits are " + this.tag + ", the memory block, in decimal, is " + this.intBlockDecMem + ".");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.memoryPanel.boolBlocks[this.intBlockDecMem] = true;
                    this.memoryPanel.boolWords[this.intWordDec] = true;
                    continue block11;
                }
                case 5: {
                    this.memoryPanel.boolBlocks[this.intBlockDecMem] = false;
                    this.memoryPanel.boolWords[this.intWordDec] = false;
                    if (this.memInCache == -1 && this.emptyCacheBlock != -1) {
                        if (n == this.moveStatus) {
                            this.tProgress.setText("As we saw earlier, the required memory block was not in cache.\nSince there was empty space in cache, we brought the memory block into it.\nWe also stored the tag, " + this.tag + ", of the memory block with the cache block." + "\n\nRemember that the memory block could be brought into any empty cache block." + "\nIn our example, we are using the first available empty block.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.statusCacheLRU[this.emptyCacheBlock] = ++this.statusLRU;
                        this.statusCacheEmpty[this.emptyCacheBlock] = false;
                        this.cachePanel.stringBlocks[this.emptyCacheBlock] = "" + this.intBlockDecMem;
                        this.cachePanel.tag[this.emptyCacheBlock] = this.tag;
                        this.cachePanel.boolBlocks[this.emptyCacheBlock] = true;
                        this.cachePanel.boolWords[this.intWordDec] = true;
                        this.cachePanel.boolTags[this.emptyCacheBlock] = true;
                        this.intBlockDec = this.emptyCacheBlock;
                        continue block11;
                    }
                    if (this.memInCache >= 0 && this.memInCache < 16) {
                        if (n == this.moveStatus) {
                            this.tProgress.setText("As we saw earlier, the required memory block is already in cache.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.statusCacheLRU[this.memInCache] = ++this.statusLRU;
                        this.cachePanel.boolBlocks[this.memInCache] = true;
                        this.cachePanel.boolWords[this.intWordDec] = true;
                        this.cachePanel.boolTags[this.memInCache] = true;
                        this.intBlockDec = this.memInCache;
                        continue block11;
                    }
                    this.lruCacheBlock = this.getLRUCacheBlock();
                    if (n == this.moveStatus) {
                        this.tProgress.setText("As we saw earlier, the cache is full.\nSo we picked the least recently used cache block, " + this.lruCacheBlock + ", and replaced it with the required memory block.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.statusCacheLRU[this.lruCacheBlock] = ++this.statusLRU;
                    this.statusCacheEmpty[this.lruCacheBlock] = false;
                    this.cachePanel.stringBlocks[this.lruCacheBlock] = "" + this.intBlockDecMem;
                    this.cachePanel.tag[this.lruCacheBlock] = this.tag;
                    this.cachePanel.boolBlocks[this.lruCacheBlock] = true;
                    this.cachePanel.boolWords[this.intWordDec] = true;
                    this.cachePanel.boolTags[this.lruCacheBlock] = true;
                    this.intBlockDec = this.lruCacheBlock;
                    continue block11;
                }
                case 0: {
                    this.cachePanel.boolBlocks[this.intBlockDec] = false;
                    this.cachePanel.boolWords[this.intWordDec] = false;
                    this.cachePanel.boolTags[this.intBlockDec] = false;
                    this.tTag.setText("");
                    this.tWord.setText("");
                    this.tTag.setBackground(new Color(205, 205, 205));
                    this.tWord.setBackground(new Color(205, 205, 205));
                    this.addRefStrList.clearSelection();
                    ++this.evaluateIndex;
                    if (this.evaluateIndex == this.listData.size()) {
                        if (n == this.moveStatus) {
                            this.tProgress.setText("This completes the runthrough.\nPlease click on \"Restart\", generate the Address Reference String OR click \"Quit\" to finish.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.next.setEnabled(false);
                        this.autoGen.setEnabled(true);
                        this.selfGen.setEnabled(true);
                        this.reStarted = false;
                        continue block11;
                    }
                    if (n == this.moveStatus) {
                        this.tProgress.setText("This completes an access cycle.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.addRefStrList.clearSelection();
                    continue block11;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Uh Oh, there's a problem in switch-case!");
                }
            }
        }
        this.repaint();
    }

    public void createAddresses() {
        int n = -1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.addresses[++n] = this.tempAddress[i] + this.tempAddress[j];
            }
        }
    }

    public void autoGenerateString() {
        for (int i = 0; i < 10; ++i) {
            int n = (int)(Math.random() * 256.0);
            this.listData.add(this.addresses[n]);
        }
        this.addRefStrList.setListData(this.listData);
        this.next.setEnabled(true);
        this.back.setEnabled(false);
        this.tProgress.setText("We have automatically generated an address string of 10 addresses for you to work with.\nClick on \"Next\" to continue.");
    }

    public void selfGenerateString() {
        int n = 0;
        int n2 = 0;
        JTextField jTextField = new JTextField();
        Object[] objectArray = new Object[]{"Enter String", jTextField};
        Object[] objectArray2 = new Object[]{"Continue", "Done"};
        while (n == 0 && n2 < 10) {
            n = JOptionPane.showOptionDialog(this, objectArray, "Self Generate", 0, 3, null, objectArray2, objectArray2[0]);
            if (n == 0) {
                if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                    this.listData.add(jTextField.getText().toUpperCase());
                    ++n2;
                } else {
                    JOptionPane.showMessageDialog(this, "Invalid Input. Please try again.", "Invalid Input", 0);
                }
                jTextField.setText("");
                continue;
            }
            if (n != 1 || jTextField.getText().equals("")) continue;
            if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                this.listData.add(jTextField.getText().toUpperCase());
                this.tProgress.setText("You have generated an Address Reference String of " + ++n2 + " address." + "\nPlease click on \"Next\" to continue.");
                this.tProgress.setCaretPosition(0);
                continue;
            }
            JOptionPane.showMessageDialog(this, "Invalid Input. Quitting without saving last entry.", "Invalid Input", 0);
            this.tProgress.setText("You have generated an Address Reference String of " + n2 + " address." + "\nPlease click on \"Next\" to continue.");
            this.tProgress.setCaretPosition(0);
        }
        this.addRefStrList.setListData(this.listData);
        if (n2 > 0) {
            this.next.setEnabled(true);
            this.back.setEnabled(false);
        }
    }

    public boolean validateInput(String string) {
        for (int i = 0; i < 256; ++i) {
            if (!this.addresses[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getCacheBlock(String string) {
        for (int i = 0; i < 16; ++i) {
            if (!string.equals(this.cachePanel.tag[i])) continue;
            return i;
        }
        return -1;
    }

    public int getFirstEmptyCacheBlock() {
        for (int i = 0; i < 16; ++i) {
            if (!this.statusCacheEmpty[i]) continue;
            return i;
        }
        return -1;
    }

    public int getLRUCacheBlock() {
        int n = 0;
        for (int i = 1; i < 16; ++i) {
            if (this.statusCacheLRU[n] <= this.statusCacheLRU[i]) continue;
            n = i;
        }
        return n;
    }

    public void removeInstance() {
        this.dispose();
    }
}

