/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

class PageTablePanel
extends JPanel {
    boolean[] boolRows = new boolean[8];
    String[] frameNum = new String[8];
    String[] validBit = new String[8];
    private Dimension dP;
    private int dx;
    private int dy;
    private int offsetX;
    private int offsetY;

    public PageTablePanel() {
        this.setPreferredSize(new Dimension(340, 240));
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createTitledBorder(border, " Page Table "));
        for (int i = 0; i < 8; ++i) {
            this.frameNum[i] = "-";
            this.validBit[i] = "0";
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        this.dP = this.getSize();
        this.dP.height -= 20;
        this.dP.width -= 20;
        this.dy = this.dP.height / 9;
        int n2 = this.dy * 9;
        this.offsetY = 18;
        this.dx = (this.dP.width - 20) / 2;
        this.offsetX = 20;
        graphics.setColor(Color.black);
        for (n = 0; n < 10; ++n) {
            graphics.drawLine(this.offsetX, this.offsetY + this.dy * n, this.offsetX + 2 * this.dx, this.offsetY + this.dy * n);
        }
        graphics.drawString("Frame Number", this.offsetX + 33, this.offsetY + 17);
        graphics.drawString("Valid Bit", this.offsetX + this.dx + 50, this.offsetY + 17);
        for (n = 0; n < 8; ++n) {
            graphics.drawString("" + n, this.offsetX / 2, this.offsetY + this.dy * (n + 1) + 17);
            graphics.drawString(this.frameNum[n], this.offsetX + this.dx / 2, this.offsetY + this.dy * (n + 1) + 17);
            graphics.drawString(this.validBit[n], this.offsetX + 3 * this.dx / 2, this.offsetY + this.dy * (n + 1) + 17);
        }
        graphics.drawLine(this.offsetX, this.offsetY, this.offsetX, this.offsetY + n2);
        graphics.drawLine(this.offsetX + this.dx, this.offsetY, this.offsetX + this.dx, this.offsetY + n2);
        graphics.drawLine(this.offsetX + 2 * this.dx, this.offsetY, this.offsetX + 2 * this.dx, this.offsetY + n2);
        for (n = 1; n < 9; ++n) {
            if (!this.boolRows[n - 1]) continue;
            graphics.setColor(Color.pink);
            graphics.fillRect(this.offsetX + 1, this.offsetY + 1 + this.dy * n, this.dx - 1, this.dy - 1);
            graphics.fillRect(this.offsetX + 1 + this.dx, this.offsetY + 1 + this.dy * n, this.dx - 1, this.dy - 1);
            graphics.setColor(Color.black);
            graphics.drawString(this.frameNum[n - 1], this.offsetX + this.dx / 2, this.offsetY + this.dy * n + 17);
            graphics.drawString(this.validBit[n - 1], this.offsetX + 3 * this.dx / 2, this.offsetY + this.dy * n + 17);
            break;
        }
    }
}

