/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

class PhysicalMemoryPanel
extends JPanel {
    boolean[] boolFrames = new boolean[4];
    boolean[] boolWords = new boolean[32];
    String[][] stringWords = new String[4][32];
    Dimension dM;
    int dxM;
    int dyM;
    int offsetXM;
    int offsetYM;

    public PhysicalMemoryPanel() {
        this.setPreferredSize(new Dimension(395, 330));
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createTitledBorder(border, " Physical Memory "));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.stringWords[i][j] = "";
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        this.dM = this.getSize();
        this.dM.height -= 20;
        this.dM.height -= 5;
        this.dyM = this.dM.height / 16;
        int n3 = this.dyM * 16;
        this.offsetYM = 18;
        this.dM.width -= 20;
        this.dM.width -= 5;
        this.dxM = (this.dM.width - 35) / 8;
        int n4 = this.dxM * 8;
        this.offsetXM = (this.dM.width - n4 - 35) / 2;
        graphics.setFont(new Font("TimesRoman", 0, 10));
        graphics.setColor(Color.black);
        for (n2 = 0; n2 < 17; ++n2) {
            graphics.drawLine(this.offsetXM + 50, this.offsetYM + this.dyM * n2, this.offsetXM + 50 + n4, this.offsetYM + this.dyM * n2);
        }
        for (n2 = 0; n2 < 9; ++n2) {
            graphics.drawLine(this.offsetXM + this.dxM * n2 + 50, this.offsetYM, this.offsetXM + this.dxM * n2 + 50, this.offsetYM + n3);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 32; ++n) {
                graphics.drawString(this.stringWords[n2][n], this.offsetXM + this.dxM * (n % 8) + 52, this.dyM * n2 * 4 + this.offsetYM + this.dyM * (n / 8) + 14);
            }
        }
        for (n2 = 1; n2 < 5; ++n2) {
            graphics.drawString("Page " + (n2 - 1), this.offsetXM + 2, this.offsetYM + this.dyM * 2 * (n2 - 1) + this.dyM * 2 * n2);
            graphics.drawString("Frame", this.offsetXM + 2, this.offsetYM + this.dyM * 2 * (n2 - 1) + this.dyM * 2 * n2 + 12);
        }
        for (n2 = 1; n2 < 50; n2 += 16) {
            graphics.drawLine(this.offsetXM + 43, this.offsetYM + n2 * this.dyM / 4, this.offsetXM + 45, this.offsetYM + n2 * this.dyM / 4);
            graphics.drawLine(this.offsetXM + 43, this.offsetYM + n2 * this.dyM / 4, this.offsetXM + 43, this.offsetYM + (n2 + 14) * this.dyM / 4);
            graphics.drawLine(this.offsetXM + 43, this.offsetYM + (n2 + 14) * this.dyM / 4, this.offsetXM + 45, this.offsetYM + (n2 + 14) * this.dyM / 4);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (!this.boolFrames[n2]) continue;
            graphics.setColor(Color.blue);
            for (n = 0; n < 4; ++n) {
                for (int i = 0; i < 8; ++i) {
                    graphics.fillRect(this.offsetXM + this.dxM * i + 51, this.dyM * n2 * 4 + this.offsetYM + this.dyM * n + 1, this.dxM - 1, this.dyM - 1);
                }
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (!this.boolFrames[n2]) continue;
            for (n = 0; n < 32; ++n) {
                if (!this.boolWords[n]) continue;
                graphics.setColor(Color.black);
                graphics.fillRect(this.offsetXM + this.dxM * (n % 8) + 51, this.dyM * n2 * 4 + this.offsetYM + 1 + this.dyM * (n / 8), this.dxM - 1, this.dyM - 1);
            }
            break;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (!this.boolFrames[n2]) continue;
            graphics.setColor(Color.white);
            for (n = 0; n < 32; ++n) {
                graphics.drawString(this.stringWords[n2][n], this.offsetXM + this.dxM * (n % 8) + 52, this.dyM * n2 * 4 + this.offsetYM + this.dyM * (n / 8) + 14);
            }
        }
    }
}

