/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

class SACFrame
extends JFrame {
    private SACachePanel cachePanel;
    private MemoryPanel memoryPanel;
    private JPanel bottomPanel;
    private JPanel cache;
    private JPanel cacheHitsMisses;
    private JPanel cacheWays;
    private JPanel cacheHitsMissesWays;
    private JPanel pEastPanel;
    private JPanel pAddRefStr;
    private JPanel pAutoSelfGen;
    private JPanel pBitsInMM1;
    private JPanel pBitsInMM2;
    private JPanel pBitsInMM;
    private JButton restart;
    private JButton next;
    private JButton back;
    private JButton quit;
    private JButton autoGen;
    private JButton selfGen;
    private JLabel lNumWays;
    private JLabel lCacheHits;
    private JLabel lCacheMisses;
    private JLabel lProgress;
    private JLabel lBits1;
    private JLabel lBits2;
    private JTextField tCacheHits;
    private JTextField tCacheMisses;
    private JTextField tTag;
    private JTextField tSet;
    private JTextField tBlock;
    private JTextField tWord1;
    private JTextField tWord2;
    private JComboBox cNumWays;
    private String[] numWays = new String[]{"2", "4"};
    private JTextArea tProgress;
    private JScrollPane progressScroll;
    private JScrollPane addRefStrScroll;
    private JList addRefStrList;
    private Border cacheHMBorder;
    private Border bitsInMM1Border;
    private Border bitsInMM2Border;
    private Border bitsInMMBorder;
    private Border addRefStrBorder;
    String[] tempAddress = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String[] addresses = new String[256];
    private Vector listData = new Vector();
    private int moveStatus = 0;
    private int evaluateIndex = 0;
    private int numWaysSel = 0;
    private int cacheHits;
    private int cacheMisses;
    private String hexAddress = new String();
    private String binAddress = new String();
    private int intSetDec = 0;
    private int intWordDec = 0;
    private int intBlockDecMem = 0;
    private int intBlockDec = 0;
    private int memInCacheBlock = -1;
    private String tag = new String();
    private String set = new String();
    private String word = new String();
    private String blockMem = new String();
    private String blockDec = new String();
    private String wordDec = new String();
    private int emptyCacheBlock = -1;
    private int lruCacheBlock = -1;
    private int statusLRU;
    private int[][] statusCacheLRU2Way = new int[8][2];
    private boolean[][] statusCacheEmpty2Way = new boolean[8][2];
    private int[][] statusCacheLRU4Way = new int[4][4];
    private boolean[][] statusCacheEmpty4Way = new boolean[4][4];
    private boolean reStarted = true;
    private boolean nextClicked = true;

    public SACFrame() {
        int n;
        int n2;
        this.setTitle("Set Associative Cache");
        this.setDefaultCloseOperation(2);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(SACFrame.class.getResource("cam.gif")));
        this.restart = new JButton("Restart");
        this.next = new JButton("Next");
        this.back = new JButton("Back");
        this.quit = new JButton("Quit");
        this.lCacheHits = new JLabel("Cache Hits");
        this.lCacheMisses = new JLabel("Cache Misses");
        this.tCacheHits = new JTextField(5);
        this.tCacheMisses = new JTextField(5);
        this.tCacheHits.setEditable(false);
        this.tCacheHits.setFont(new Font("Monospaced", 1, 14));
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setEditable(false);
        this.tCacheMisses.setFont(new Font("Monospaced", 1, 14));
        this.tCacheMisses.setText("  0");
        this.lNumWays = new JLabel("Ways");
        this.cNumWays = new JComboBox<String>(this.numWays);
        this.tProgress = new JTextArea(3, 45);
        this.tProgress.setEditable(false);
        this.tProgress.setLineWrap(true);
        this.tProgress.setWrapStyleWord(true);
        this.tProgress.setCaretPosition(0);
        this.tProgress.setFont(new Font("Serif", 3, 16));
        this.tProgress.setText("Welcome to Set Associative Cache!\nThe system specs are as follows -\n  16 Blocks in Cache\n  32 Blocks in Main Memory\n  8 words per block\nPlease select the number of ways in cache and generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.progressScroll = new JScrollPane();
        this.progressScroll.getViewport().add(this.tProgress);
        this.progressScroll.setVerticalScrollBarPolicy(22);
        this.lProgress = new JLabel("PROGRESS UPDATE");
        this.addRefStrList = new JList();
        this.addRefStrList.setEnabled(false);
        this.addRefStrScroll = new JScrollPane();
        this.addRefStrScroll.getViewport().setView(this.addRefStrList);
        this.addRefStrScroll.setVerticalScrollBarPolicy(22);
        this.addRefStrScroll.setPreferredSize(new Dimension(140, 300));
        this.autoGen = new JButton("Auto Generate Add. Ref. Str.");
        this.selfGen = new JButton("Self Generate Add. Ref. Str.");
        this.lBits1 = new JLabel("   TAG                 SET             WORD");
        this.lBits2 = new JLabel("                 BLOCK                  WORD");
        this.tTag = new JTextField(6);
        this.tTag.setEditable(false);
        this.tSet = new JTextField();
        this.tSet.setEditable(false);
        this.tBlock = new JTextField();
        this.tBlock.setEditable(false);
        this.tWord1 = new JTextField(6);
        this.tWord1.setEditable(false);
        this.tWord2 = new JTextField(6);
        this.tWord2.setEditable(false);
        this.tTag.setFont(new Font("Monospaced", 1, 14));
        this.tSet.setFont(new Font("Monospaced", 1, 14));
        this.tWord1.setFont(new Font("Monospaced", 1, 14));
        this.tBlock.setFont(new Font("Monospaced", 1, 14));
        this.tWord2.setFont(new Font("Monospaced", 1, 14));
        this.cNumWays.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((SACFrame)SACFrame.this).cachePanel.numWays = SACFrame.this.cNumWays.getSelectedIndex();
                SACFrame.this.repaint();
            }
        });
        this.restart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SACFrame.this.reStart();
            }
        });
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SACFrame.this.nextClicked = true;
                SACFrame.this.step();
            }
        });
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SACFrame.this.nextClicked = false;
                SACFrame.this.step();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Really Quit?", "Quit Confirmation", 0, 3);
                switch (n) {
                    case 0: {
                        SACFrame.this.removeInstance();
                    }
                }
            }
        });
        this.autoGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SACFrame.this.autoGenerateString();
            }
        });
        this.selfGen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SACFrame.this.selfGenerateString();
            }
        });
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.cachePanel = new SACachePanel();
        this.memoryPanel = new MemoryPanel();
        this.bottomPanel = new JPanel();
        this.cache = new JPanel();
        this.cacheHitsMisses = new JPanel();
        this.cacheWays = new JPanel();
        this.cacheHitsMissesWays = new JPanel();
        this.pAutoSelfGen = new JPanel();
        this.pAddRefStr = new JPanel();
        this.pEastPanel = new JPanel();
        this.pBitsInMM = new JPanel();
        this.pBitsInMM1 = new JPanel();
        this.pBitsInMM2 = new JPanel();
        this.bottomPanel.add(this.lProgress);
        this.bottomPanel.add(this.progressScroll);
        this.bottomPanel.add(this.restart);
        this.bottomPanel.add(this.next);
        this.bottomPanel.add(this.back);
        this.bottomPanel.add(this.quit);
        this.cacheHitsMisses.add(this.lCacheHits);
        this.cacheHitsMisses.add(this.tCacheHits);
        this.cacheHitsMisses.add(this.lCacheMisses);
        this.cacheHitsMisses.add(this.tCacheMisses);
        this.cacheWays.add(this.lNumWays);
        this.cacheWays.add(this.cNumWays);
        this.cacheHitsMissesWays.setLayout(new BorderLayout());
        this.cacheHitsMissesWays.add((Component)this.cacheWays, "North");
        this.cacheHitsMissesWays.add((Component)this.cacheHitsMisses, "South");
        this.cacheHMBorder = BorderFactory.createEtchedBorder();
        this.cacheHitsMissesWays.setBorder(BorderFactory.createTitledBorder(this.cacheHMBorder, ""));
        this.cache.setLayout(new BorderLayout());
        this.cache.add((Component)this.cachePanel, "Center");
        this.cache.add((Component)this.cacheHitsMissesWays, "South");
        this.pAutoSelfGen.setLayout(new GridLayout(2, 1));
        this.pAutoSelfGen.add(this.autoGen);
        this.pAutoSelfGen.add(this.selfGen);
        this.pAddRefStr.setLayout(new BorderLayout());
        this.pAddRefStr.setPreferredSize(new Dimension(160, 400));
        this.pAddRefStr.add((Component)this.addRefStrScroll, "Center");
        this.pAddRefStr.add((Component)this.pAutoSelfGen, "South");
        this.addRefStrBorder = BorderFactory.createEtchedBorder();
        this.pAddRefStr.setBorder(BorderFactory.createTitledBorder(this.addRefStrBorder, " Address Reference String "));
        this.pBitsInMM1.setLayout(new BorderLayout());
        this.bitsInMM1Border = BorderFactory.createEtchedBorder();
        this.pBitsInMM1.setBorder(BorderFactory.createTitledBorder(this.bitsInMM1Border, " Main Memory Address "));
        this.pBitsInMM1.add((Component)this.tTag, "West");
        this.pBitsInMM1.add((Component)this.tSet, "Center");
        this.pBitsInMM1.add((Component)this.tWord1, "East");
        this.pBitsInMM1.add((Component)this.lBits1, "South");
        this.pBitsInMM2.setLayout(new BorderLayout());
        this.bitsInMM2Border = BorderFactory.createEtchedBorder();
        this.pBitsInMM2.setBorder(BorderFactory.createTitledBorder(this.bitsInMM2Border, " Memory Block and Word Bits "));
        this.pBitsInMM2.add((Component)this.tBlock, "Center");
        this.pBitsInMM2.add((Component)this.tWord2, "East");
        this.pBitsInMM2.add((Component)this.lBits2, "South");
        this.pBitsInMM.setLayout(new GridLayout(2, 1));
        this.bitsInMMBorder = BorderFactory.createEtchedBorder();
        this.pBitsInMM.setBorder(BorderFactory.createTitledBorder(this.bitsInMMBorder, ""));
        this.pBitsInMM.add(this.pBitsInMM1);
        this.pBitsInMM.add(this.pBitsInMM2);
        this.pEastPanel.setLayout(new BorderLayout());
        this.pEastPanel.setPreferredSize(new Dimension(210, 600));
        this.pEastPanel.add((Component)this.pAddRefStr, "Center");
        this.pEastPanel.add((Component)this.pBitsInMM, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.cache, "West");
        container.add((Component)this.memoryPanel, "Center");
        container.add((Component)this.pEastPanel, "East");
        container.add((Component)this.bottomPanel, "South");
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.statusCacheLRU2Way[n2][n] = 0;
                this.statusCacheEmpty2Way[n2][n] = true;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.statusCacheLRU4Way[n2][n] = 0;
                this.statusCacheEmpty4Way[n2][n] = true;
            }
        }
        this.createAddresses();
        this.pack();
    }

    public void reStart() {
        int n;
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.cachePanel.stringBlocks2Way[n2][n] = "";
                this.cachePanel.tag2Way[n2][n] = "";
                this.cachePanel.boolBlocks2Way[n2][n] = false;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.cachePanel.stringBlocks4Way[n2][n] = "";
                this.cachePanel.tag4Way[n2][n] = "";
                this.cachePanel.boolBlocks4Way[n2][n] = false;
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.cachePanel.boolWords[n2] = false;
            this.memoryPanel.boolWords[n2] = false;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.memoryPanel.boolBlocks[n2] = false;
        }
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setText("  0");
        this.listData.removeAllElements();
        this.addRefStrList.setListData(this.listData);
        this.tTag.setText("");
        this.tSet.setText("");
        this.tBlock.setText("");
        this.tWord1.setText("");
        this.tWord2.setText("");
        this.tTag.setBackground(new Color(205, 205, 205));
        this.tSet.setBackground(new Color(205, 205, 205));
        this.tWord1.setBackground(new Color(205, 205, 205));
        this.tBlock.setBackground(new Color(205, 205, 205));
        this.tWord2.setBackground(new Color(205, 205, 205));
        this.tProgress.setText("Let's start over.\nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.autoGen.setEnabled(true);
        this.selfGen.setEnabled(true);
        this.cNumWays.setEnabled(true);
        this.moveStatus = 0;
        this.evaluateIndex = 0;
        this.numWaysSel = 0;
        this.reStarted = true;
        this.memInCacheBlock = -1;
        this.emptyCacheBlock = -1;
        this.lruCacheBlock = -1;
        this.statusLRU = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.statusCacheLRU2Way[n2][n] = 0;
                this.statusCacheEmpty2Way[n2][n] = true;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.statusCacheLRU4Way[n2][n] = 0;
                this.statusCacheEmpty4Way[n2][n] = true;
            }
        }
        this.repaint();
    }

    public void step() {
        int n;
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.cachePanel.stringBlocks2Way[n2][n] = "";
                this.cachePanel.tag2Way[n2][n] = "";
                this.cachePanel.boolBlocks2Way[n2][n] = false;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.cachePanel.stringBlocks4Way[n2][n] = "";
                this.cachePanel.tag4Way[n2][n] = "";
                this.cachePanel.boolBlocks4Way[n2][n] = false;
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.cachePanel.boolWords[n2] = false;
            this.memoryPanel.boolWords[n2] = false;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.memoryPanel.boolBlocks[n2] = false;
        }
        this.cacheHits = 0;
        this.cacheMisses = 0;
        this.tCacheHits.setText("  0");
        this.tCacheMisses.setText("  0");
        this.tTag.setText("");
        this.tSet.setText("");
        this.tBlock.setText("");
        this.tWord1.setText("");
        this.tWord2.setText("");
        this.tTag.setBackground(new Color(205, 205, 205));
        this.tSet.setBackground(new Color(205, 205, 205));
        this.tWord1.setBackground(new Color(205, 205, 205));
        this.tBlock.setBackground(new Color(205, 205, 205));
        this.tWord2.setBackground(new Color(205, 205, 205));
        this.evaluateIndex = 0;
        this.memInCacheBlock = -1;
        this.emptyCacheBlock = -1;
        this.lruCacheBlock = -1;
        this.statusLRU = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 2; ++n) {
                this.statusCacheLRU2Way[n2][n] = 0;
                this.statusCacheEmpty2Way[n2][n] = true;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                this.statusCacheLRU4Way[n2][n] = 0;
                this.statusCacheEmpty4Way[n2][n] = true;
            }
        }
        this.autoGen.setEnabled(false);
        this.selfGen.setEnabled(false);
        this.cNumWays.setEnabled(false);
        if (this.nextClicked) {
            ++this.moveStatus;
        } else {
            --this.moveStatus;
            this.next.setEnabled(true);
        }
        if (this.moveStatus == 0) {
            this.back.setEnabled(false);
            this.tProgress.setText("You cannot go back any further.\nPlease click on \"Next\" or \"Restart\" to continue.");
            this.tProgress.setCaretPosition(0);
            this.addRefStrList.clearSelection();
        } else {
            this.back.setEnabled(true);
        }
        block18: for (n2 = 1; n2 <= this.moveStatus; ++n2) {
            switch (n2 % 6) {
                case 1: {
                    int n3;
                    this.addRefStrList.setSelectedIndex(this.evaluateIndex);
                    if (n2 == this.moveStatus) {
                        this.addRefStrList.ensureIndexIsVisible(this.evaluateIndex);
                    }
                    this.numWaysSel = this.cNumWays.getSelectedIndex();
                    this.hexAddress = (String)this.addRefStrList.getSelectedValue();
                    n = Integer.parseInt(this.hexAddress, 16);
                    this.binAddress = Integer.toBinaryString(n);
                    if (this.binAddress.length() < 8) {
                        n3 = 8 - this.binAddress.length();
                        for (int i = 0; i < n3; ++i) {
                            this.binAddress = '0' + this.binAddress;
                        }
                    }
                    if (this.numWaysSel == 0) {
                        this.tag = this.binAddress.substring(0, 2);
                        this.set = this.binAddress.substring(2, 5);
                    } else {
                        this.tag = this.binAddress.substring(0, 3);
                        this.set = this.binAddress.substring(3, 5);
                    }
                    this.word = this.binAddress.substring(5);
                    this.blockMem = this.binAddress.substring(0, 5);
                    this.intSetDec = Integer.parseInt(this.set, 2);
                    this.intWordDec = Integer.parseInt(this.word, 2);
                    this.intBlockDecMem = Integer.parseInt(this.blockMem, 2);
                    if (n2 != this.moveStatus) continue block18;
                    this.tProgress.setText("The memory address we want is obtained from the Address Reference String.\nIt is (in hexadecimal): " + this.hexAddress + ".");
                    this.tProgress.setCaretPosition(0);
                    continue block18;
                }
                case 2: {
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("The hexadecimal address " + this.hexAddress + " evaluates to its binary equivalent " + this.binAddress + "." + "\nHence the bits in the Main Memory Address are divided into the following fields\n" + this.tag + " --> Tag,  " + this.set + " --> Set,  " + this.word + " --> Word." + "\nThe above field values are used to access the required cache block." + "\n\nFrom the 8 bit binary address, " + this.binAddress + ", evaluated above " + "we can also retrieve the following data:" + "\nThe leftmost 5 bits, " + this.blockMem + ", and the rightmost 3 bits, " + this.word + ", indicate the actual memory block and word in question, respectively.");
                        this.tProgress.setCaretPosition(0);
                        this.tTag.setBackground(Color.green);
                        this.tSet.setBackground(Color.green);
                        this.tWord1.setBackground(Color.green);
                        this.tBlock.setBackground(Color.green);
                        this.tWord2.setBackground(Color.green);
                    }
                    this.tTag.setText(" " + this.tag);
                    this.tSet.setText("    " + this.set);
                    this.tWord1.setText(" " + this.word);
                    this.tBlock.setText("      " + this.tag + this.set);
                    this.tWord2.setText(" " + this.word);
                    continue block18;
                }
                case 3: {
                    int n3;
                    this.tTag.setBackground(new Color(205, 205, 205));
                    this.tSet.setBackground(new Color(205, 205, 205));
                    this.tWord1.setBackground(new Color(205, 205, 205));
                    this.tBlock.setBackground(new Color(205, 205, 205));
                    this.tWord2.setBackground(new Color(205, 205, 205));
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("The bits in the Main Memory Address indicating the cache set are " + this.set + ". The equivalent set number in decimal is, therefore, " + this.intSetDec + ". The bits identifying the memory block within the cache set are the tag bits " + this.tag + " so, the block with this tag in the set " + this.intSetDec + " is searched in the cache.");
                        this.tProgress.setCaretPosition(0);
                    }
                    if (this.numWaysSel == 0) {
                        this.cachePanel.boolBlocks2Way[this.intSetDec][0] = true;
                        this.cachePanel.boolBlocks2Way[this.intSetDec][1] = true;
                        this.memInCacheBlock = this.getCacheBlock(this.numWaysSel, this.intSetDec, this.tag);
                        if (this.memInCacheBlock == -1) {
                            ++this.cacheMisses;
                            this.tCacheMisses.setText("  " + this.cacheMisses);
                            if (n2 != this.moveStatus) continue block18;
                            this.tProgress.append("\nSince the matching tag was not found in the set, there was a cache miss.");
                            this.tProgress.setCaretPosition(0);
                            continue block18;
                        }
                        ++this.cacheHits;
                        this.tCacheHits.setText("  " + this.cacheHits);
                        if (n2 != this.moveStatus) continue block18;
                        this.tProgress.append("\nSince the matching tag was found in the set, there was a cache hit.");
                        this.tProgress.setCaretPosition(0);
                        continue block18;
                    }
                    if (this.numWaysSel != 1) continue block18;
                    for (n3 = 0; n3 < 4; ++n3) {
                        this.cachePanel.boolBlocks4Way[this.intSetDec][n3] = true;
                    }
                    this.memInCacheBlock = this.getCacheBlock(this.numWaysSel, this.intSetDec, this.tag);
                    if (this.memInCacheBlock == -1) {
                        ++this.cacheMisses;
                        this.tCacheMisses.setText("  " + this.cacheMisses);
                        if (n2 != this.moveStatus) continue block18;
                        this.tProgress.append("\nSince the matching tag was not found in the set, there was a cache miss.");
                        this.tProgress.setCaretPosition(0);
                        continue block18;
                    }
                    ++this.cacheHits;
                    this.tCacheHits.setText("  " + this.cacheHits);
                    if (n2 != this.moveStatus) continue block18;
                    this.tProgress.append("\nSince the matching tag was found in the set, there was a cache hit.");
                    this.tProgress.setCaretPosition(0);
                    continue block18;
                }
                case 4: {
                    int n3;
                    if (this.numWaysSel == 0) {
                        this.cachePanel.boolBlocks2Way[this.intSetDec][0] = false;
                        this.cachePanel.boolBlocks2Way[this.intSetDec][1] = false;
                    } else if (this.numWaysSel == 1) {
                        for (n3 = 0; n3 < 4; ++n3) {
                            this.cachePanel.boolBlocks4Way[this.intSetDec][n3] = false;
                        }
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("Since the leftmost 5 bits of the address reference string are " + this.blockMem + ", the main memory block in question is, in decimal, " + this.intBlockDecMem + ".");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.memoryPanel.boolBlocks[this.intBlockDecMem] = true;
                    this.memoryPanel.boolWords[this.intWordDec] = true;
                    continue block18;
                }
                case 5: {
                    this.memoryPanel.boolBlocks[this.intBlockDecMem] = false;
                    this.memoryPanel.boolWords[this.intWordDec] = false;
                    this.memInCacheBlock = this.getCacheBlock(this.numWaysSel, this.intSetDec, this.tag);
                    if (this.memInCacheBlock == -1) {
                        this.emptyCacheBlock = this.getFirstEmptyCacheBlock(this.numWaysSel, this.intSetDec);
                        if (this.emptyCacheBlock != -1) {
                            if (n2 == this.moveStatus) {
                                this.tProgress.setText("As we saw earlier, the required memory block was not in the cache set.\nSince there was an empty block in the set, we brought the memory block into it.\nWe also stored the tag, " + this.tag + ", of the memory block with the cache block." + "\n\nRemember that the memory block could be brought into any empty cache block." + "\nIn our example, we are using the first available empty block in the set.");
                                this.tProgress.setCaretPosition(0);
                            }
                            if (this.numWaysSel == 0) {
                                this.statusCacheLRU2Way[this.intSetDec][this.emptyCacheBlock] = ++this.statusLRU;
                                this.statusCacheEmpty2Way[this.intSetDec][this.emptyCacheBlock] = false;
                                this.cachePanel.stringBlocks2Way[this.intSetDec][this.emptyCacheBlock] = "" + this.intBlockDecMem;
                                this.cachePanel.tag2Way[this.intSetDec][this.emptyCacheBlock] = this.tag;
                                this.cachePanel.boolBlocks2Way[this.intSetDec][this.emptyCacheBlock] = true;
                                this.cachePanel.boolWords[this.intWordDec] = true;
                            } else if (this.numWaysSel == 1) {
                                this.cachePanel.stringBlocks4Way[this.intSetDec][this.emptyCacheBlock] = "" + this.intBlockDecMem;
                                this.cachePanel.tag4Way[this.intSetDec][this.emptyCacheBlock] = this.tag;
                                this.statusCacheLRU4Way[this.intSetDec][this.emptyCacheBlock] = ++this.statusLRU;
                                this.statusCacheEmpty4Way[this.intSetDec][this.emptyCacheBlock] = false;
                                this.cachePanel.boolBlocks4Way[this.intSetDec][this.emptyCacheBlock] = true;
                                this.cachePanel.boolWords[this.intWordDec] = true;
                            }
                            this.intBlockDec = this.emptyCacheBlock;
                            continue block18;
                        }
                        this.lruCacheBlock = this.getLRUCacheBlock(this.numWaysSel, this.intSetDec);
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("As we saw earlier, the required memory block was not in the cache set.\nSince the cache set is full, we brought the memory block into the least recently used block in that set.\nWe also stored the tag, " + this.tag + ", of the memory block with the cache block." + "\n\nRemember that the memory block could be brought into any empty cache block." + "\nIn our example, we are using the first available empty block in the set.");
                            this.tProgress.setCaretPosition(0);
                        }
                        if (this.numWaysSel == 0) {
                            this.cachePanel.stringBlocks2Way[this.intSetDec][this.lruCacheBlock] = "" + this.intBlockDecMem;
                            this.cachePanel.tag2Way[this.intSetDec][this.lruCacheBlock] = this.tag;
                            this.statusCacheLRU2Way[this.intSetDec][this.lruCacheBlock] = ++this.statusLRU;
                            this.cachePanel.boolBlocks2Way[this.intSetDec][this.lruCacheBlock] = true;
                            this.cachePanel.boolWords[this.intWordDec] = true;
                        } else if (this.numWaysSel == 1) {
                            this.cachePanel.stringBlocks4Way[this.intSetDec][this.lruCacheBlock] = "" + this.intBlockDecMem;
                            this.cachePanel.tag4Way[this.intSetDec][this.lruCacheBlock] = this.tag;
                            this.statusCacheLRU4Way[this.intSetDec][this.lruCacheBlock] = ++this.statusLRU;
                            this.cachePanel.boolBlocks4Way[this.intSetDec][this.lruCacheBlock] = true;
                            this.cachePanel.boolWords[this.intWordDec] = true;
                        }
                        this.intBlockDec = this.lruCacheBlock;
                        continue block18;
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("As we saw earlier, the required memory block is already in the cache.");
                        this.tProgress.setCaretPosition(0);
                    }
                    if (this.numWaysSel == 0) {
                        this.statusCacheLRU2Way[this.intSetDec][this.memInCacheBlock] = ++this.statusLRU;
                        this.cachePanel.boolBlocks2Way[this.intSetDec][this.memInCacheBlock] = true;
                        this.cachePanel.boolWords[this.intWordDec] = true;
                    } else {
                        this.statusCacheLRU4Way[this.intSetDec][this.memInCacheBlock] = ++this.statusLRU;
                        this.cachePanel.boolBlocks4Way[this.intSetDec][this.memInCacheBlock] = true;
                        this.cachePanel.boolWords[this.intWordDec] = true;
                    }
                    this.intBlockDec = this.memInCacheBlock;
                    continue block18;
                }
                case 0: {
                    if (this.numWaysSel == 0) {
                        this.cachePanel.boolBlocks2Way[this.intSetDec][this.intBlockDec] = false;
                        this.cachePanel.boolWords[this.intWordDec] = false;
                    } else {
                        this.cachePanel.boolBlocks4Way[this.intSetDec][this.intBlockDec] = false;
                        this.cachePanel.boolWords[this.intWordDec] = false;
                    }
                    this.tTag.setText("");
                    this.tSet.setText("");
                    this.tWord1.setText("");
                    this.tBlock.setText("");
                    this.tWord2.setText("");
                    this.tTag.setBackground(new Color(205, 205, 205));
                    this.tSet.setBackground(new Color(205, 205, 205));
                    this.tBlock.setBackground(new Color(205, 205, 205));
                    this.tWord1.setBackground(new Color(205, 205, 205));
                    this.tWord2.setBackground(new Color(205, 205, 205));
                    this.addRefStrList.clearSelection();
                    ++this.evaluateIndex;
                    if (this.evaluateIndex == this.listData.size()) {
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("This completes the runthrough.\nPlease click on \"Restart\", generate an Address Reference String OR click \"Quit\" to finish.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.next.setEnabled(false);
                        this.autoGen.setEnabled(true);
                        this.selfGen.setEnabled(true);
                        this.reStarted = false;
                        continue block18;
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("This completes an access cycle.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.addRefStrList.clearSelection();
                    continue block18;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Uh Oh, there's a problem in switch-case!");
                }
            }
        }
        this.repaint();
    }

    public void createAddresses() {
        int n = -1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.addresses[++n] = this.tempAddress[i] + this.tempAddress[j];
            }
        }
    }

    public void autoGenerateString() {
        for (int i = 0; i < 10; ++i) {
            int n = (int)(Math.random() * 256.0);
            this.listData.add(this.addresses[n]);
        }
        this.addRefStrList.setListData(this.listData);
        this.next.setEnabled(true);
        this.back.setEnabled(false);
        this.tProgress.setText("We have automatically generated an address string of 10 addresses for you to work with.\nClick on \"Next\" to continue.");
    }

    public void selfGenerateString() {
        int n = 0;
        int n2 = 0;
        JTextField jTextField = new JTextField();
        Object[] objectArray = new Object[]{"Enter String", jTextField};
        Object[] objectArray2 = new Object[]{"Continue", "Done"};
        while (n == 0 && n2 < 10) {
            n = JOptionPane.showOptionDialog(this, objectArray, "Self Generate", 0, 3, null, objectArray2, objectArray2[0]);
            if (n == 0) {
                if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                    this.listData.add(jTextField.getText().toUpperCase());
                    ++n2;
                } else {
                    JOptionPane.showMessageDialog(this, "Invalid Input. Please try again.", "Invalid Input", 0);
                }
                jTextField.setText("");
                continue;
            }
            if (n != 1 || jTextField.getText().equals("")) continue;
            if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                this.listData.add(jTextField.getText().toUpperCase());
                this.tProgress.setText("You have generated an Address Reference String of " + ++n2 + " address." + "\nPlease click on \"Next\" to continue.");
                this.tProgress.setCaretPosition(0);
                continue;
            }
            JOptionPane.showMessageDialog(this, "Invalid Input. Quitting without saving last entry.", "Invalid Input", 0);
            this.tProgress.setText("You have generated an Address Reference String of " + n2 + " address." + "\nPlease click on \"Next\" to continue.");
            this.tProgress.setCaretPosition(0);
        }
        this.addRefStrList.setListData(this.listData);
        if (n2 > 0) {
            this.next.setEnabled(true);
            this.back.setEnabled(false);
        }
    }

    public boolean validateInput(String string) {
        for (int i = 0; i < 256; ++i) {
            if (!this.addresses[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getCacheBlock(int n, int n2, String string) {
        block3: {
            block2: {
                if (n != 0) break block2;
                for (int i = 0; i < 2; ++i) {
                    if (!this.cachePanel.tag2Way[n2][i].equals(string)) continue;
                    return i;
                }
                break block3;
            }
            if (n != 1) break block3;
            for (int i = 0; i < 4; ++i) {
                if (!this.cachePanel.tag4Way[n2][i].equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getFirstEmptyCacheBlock(int n, int n2) {
        if (n == 0) {
            for (int i = 0; i < 2; ++i) {
                if (!this.statusCacheEmpty2Way[n2][i]) continue;
                return i;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                if (!this.statusCacheEmpty4Way[n2][i]) continue;
                return i;
            }
        }
        return -1;
    }

    public int getLRUCacheBlock(int n, int n2) {
        int n3 = 0;
        if (n == 0) {
            if (this.statusCacheLRU2Way[n2][0] > this.statusCacheLRU2Way[n2][1]) {
                n3 = 1;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                if (this.statusCacheLRU4Way[n2][n3] <= this.statusCacheLRU4Way[n2][i]) continue;
                n3 = i;
            }
        }
        return n3;
    }

    public void removeInstance() {
        this.dispose();
    }
}

