/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

class TLBPanel
extends JPanel {
    boolean[] boolRows = new boolean[4];
    String[] virtPageNum = new String[4];
    String[] physPageNum = new String[4];
    private Dimension dT;
    private int dx;
    private int dy;
    private int offsetX;
    private int offsetY;

    public TLBPanel() {
        this.setPreferredSize(new Dimension(320, 240));
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createTitledBorder(border, " Translation Lookaside Buffer "));
        for (int i = 0; i < 4; ++i) {
            this.virtPageNum[i] = "-";
            this.physPageNum[i] = "-";
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        this.dT = this.getSize();
        this.dT.height -= 20;
        this.dT.width -= 20;
        this.dy = (this.dT.height - 20) / 5;
        int n2 = this.dy * 5;
        this.offsetY = 20;
        this.dx = this.dT.width / 2;
        this.offsetX = 10;
        graphics.setColor(Color.black);
        for (n = 0; n < 6; ++n) {
            graphics.drawLine(this.offsetX, this.offsetY + this.dy * n, this.offsetX + 2 * this.dx, this.offsetY + this.dy * n);
        }
        graphics.drawString("Virtual Page Number", this.offsetX + 15, this.offsetY + 24);
        graphics.drawString("Physical Page Number", this.offsetX + this.dx + 10, this.offsetY + 24);
        for (n = 0; n < 4; ++n) {
            graphics.drawString(this.virtPageNum[n], this.offsetX + this.dx / 2, this.offsetY + this.dy * (n + 1) + 24);
            graphics.drawString(this.physPageNum[n], this.offsetX + 3 * this.dx / 2, this.offsetY + this.dy * (n + 1) + 24);
        }
        graphics.drawLine(this.offsetX, this.offsetY, this.offsetX, this.offsetY + n2);
        graphics.drawLine(this.offsetX + this.dx, this.offsetY, this.offsetX + this.dx, this.offsetY + n2);
        graphics.drawLine(this.offsetX + 2 * this.dx, this.offsetY, this.offsetX + 2 * this.dx, this.offsetY + n2);
        for (n = 1; n < 5; ++n) {
            if (!this.boolRows[n - 1]) continue;
            graphics.setColor(Color.pink);
            graphics.fillRect(this.offsetX + 1, this.offsetY + 1 + this.dy * n, this.dx - 1, this.dy - 1);
            graphics.fillRect(this.offsetX + 1 + this.dx, this.offsetY + 1 + this.dy * n, this.dx - 1, this.dy - 1);
            graphics.setColor(Color.black);
            graphics.drawString(this.virtPageNum[n - 1], this.offsetX + this.dx / 2, this.offsetY + this.dy * n + 24);
            graphics.drawString(this.physPageNum[n - 1], this.offsetX + 3 * this.dx / 2, this.offsetY + this.dy * n + 24);
            break;
        }
    }
}

