/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

class VMFrame
extends JFrame {
    private PhysicalMemoryPanel physMemPanel;
    private VirtualMemoryPanel virtMemPanel;
    private JPanel memPanel;
    private TLBPanel tlbPanel;
    private PageTablePanel pageTablePanel;
    private JPanel bottomPanel;
    private JScrollPane bottomScrollPane;
    private JPanel pEastPanel;
    private JPanel pAddRefStr;
    private JPanel pAutoSelfGen;
    private JPanel pBits;
    private JPanel pBitsInVM;
    private JPanel pBitsInPM;
    private JPanel pTables;
    private JPanel pTLBHitsMisses;
    private JPanel pPageHitsFaults;
    private JButton restart;
    private JButton next;
    private JButton back;
    private JButton quit;
    private JButton autoGen;
    private JButton selfGen;
    private JLabel lTLBHits;
    private JLabel lTLBMisses;
    private JLabel lPageFaults;
    private JLabel lPageHits;
    private JLabel lProgress;
    private JLabel lBitsInVM;
    private JLabel lBitsInPM;
    private JTextField tTLBHits;
    private JTextField tTLBMisses;
    private JTextField tPageFaults;
    private JTextField tPageHits;
    private JTextField tPageInVM;
    private JTextField tOffsetInVM;
    private JTextField tPageInPM;
    private JTextField tOffsetInPM;
    private JTextArea tProgress;
    private JScrollPane progressScroll;
    private JScrollPane addRefStrScroll;
    private JList addRefStrList;
    private Border memBorder;
    private Border bitsInVMBorder;
    private Border bitsInPMBorder;
    private Border bitsBorder;
    private Border addRefStrBorder;
    private Border tablesBorder;
    private String[] tempAddress = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private String[] addresses = new String[256];
    private Vector listData = new Vector();
    private int moveStatus = 0;
    private int numStrings = 0;
    private int evaluateIndex = 0;
    private int tlbHits;
    private int tlbMisses;
    private int pageFaults;
    private int pageHits;
    private boolean boolTLBHit = false;
    private boolean boolPageHit = false;
    private int tlbEntry = -1;
    private int pageTableEntry = -1;
    private int emptyMemFrame = -1;
    private int lruMemFrame = -1;
    private int frameNum = -1;
    private boolean[] statusFrameEmpty = new boolean[4];
    private int[] statusFrameLRU = new int[4];
    private int statusMemFrameLRU = 0;
    private int emptyTLBRow = -1;
    private int tlbRow = -1;
    private boolean[] statusTLBRowEmpty = new boolean[4];
    private int[] statusTLBRowLRU = new int[4];
    private int statusRowLRU = 0;
    private String hexAddress = new String();
    private String binAddressVM = new String();
    private String binAddressPM = new String();
    private int physAddress;
    private int intOffsetDec = 0;
    private int intVirtPageDec = 0;
    private int intPhysPageDec = 0;
    private String virtPage = new String();
    private String offset = new String();
    private String physPage = new String();
    private String virtPageDec = new String();
    private String physPageDec = new String();
    private String offsetDec = new String();
    private boolean reStarted = true;
    private boolean nextClicked = true;

    public VMFrame() {
        this.setTitle("Virtual Memory and Paging");
        this.setDefaultCloseOperation(2);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(VMFrame.class.getResource("cam.gif")));
        this.restart = new JButton("Reset");
        this.next = new JButton("Next");
        this.back = new JButton("Back");
        this.quit = new JButton("Quit");
        this.lTLBHits = new JLabel("TLB Hits");
        this.lTLBMisses = new JLabel("TLB Misses");
        this.tTLBHits = new JTextField(5);
        this.tTLBMisses = new JTextField(5);
        this.tTLBHits.setEditable(false);
        this.tTLBHits.setFont(new Font("Monospaced", 1, 14));
        this.tTLBHits.setText("  0");
        this.tTLBMisses.setEditable(false);
        this.tTLBMisses.setFont(new Font("Monospaced", 1, 14));
        this.tTLBMisses.setText("  0");
        this.lPageHits = new JLabel("Page Hits");
        this.lPageFaults = new JLabel("Page Faults");
        this.tPageHits = new JTextField(5);
        this.tPageFaults = new JTextField(5);
        this.tPageHits.setEditable(false);
        this.tPageHits.setFont(new Font("Monospaced", 1, 14));
        this.tPageHits.setText("  0");
        this.tPageFaults.setEditable(false);
        this.tPageFaults.setFont(new Font("Monospaced", 1, 14));
        this.tPageFaults.setText("  0");
        this.tProgress = new JTextArea(3, 45);
        this.tProgress.setEditable(false);
        this.tProgress.setLineWrap(true);
        this.tProgress.setWrapStyleWord(true);
        this.tProgress.setCaretPosition(0);
        this.tProgress.setFont(new Font("Serif", 3, 16));
        this.tProgress.setText("Welcome to Virtual Memory and Paging!\nThe system specs are as follows -\n  The virtual memory space for a process is 2^8 words\n  There are 16 Blocks in Main Memory\n  8 words per block\n  Page size is 32 words, so each page contains 4 blocks.\n  So, there are 4 pages in physical memory and 8 virtual pages per process.\nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.progressScroll = new JScrollPane();
        this.progressScroll.getViewport().add(this.tProgress);
        this.progressScroll.setVerticalScrollBarPolicy(22);
        this.lProgress = new JLabel("PROGRESS UPDATE");
        this.addRefStrList = new JList();
        this.addRefStrList.setEnabled(false);
        this.addRefStrScroll = new JScrollPane();
        this.addRefStrScroll.getViewport().setView(this.addRefStrList);
        this.addRefStrScroll.setVerticalScrollBarPolicy(22);
        this.addRefStrScroll.setPreferredSize(new Dimension(140, 300));
        this.autoGen = new JButton("Auto Generate Add. Ref. Str.");
        this.selfGen = new JButton("Self Generate Add. Ref. Str.");
        this.lBitsInVM = new JLabel("     PAGE                   OFFSET");
        this.lBitsInPM = new JLabel("     PAGE                   OFFSET");
        this.tPageInVM = new JTextField(8);
        this.tPageInVM.setEditable(false);
        this.tOffsetInVM = new JTextField();
        this.tOffsetInVM.setEditable(false);
        this.tPageInPM = new JTextField(8);
        this.tPageInPM.setEditable(false);
        this.tOffsetInPM = new JTextField();
        this.tOffsetInPM.setEditable(false);
        this.tPageInVM.setFont(new Font("Monospaced", 1, 14));
        this.tPageInPM.setFont(new Font("Monospaced", 1, 14));
        this.tOffsetInVM.setFont(new Font("Monospaced", 1, 14));
        this.tOffsetInPM.setFont(new Font("Monospaced", 1, 14));
        this.restart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMFrame.this.reStart();
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMFrame.this.nextClicked = true;
                VMFrame.this.step();
            }
        });
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMFrame.this.nextClicked = false;
                VMFrame.this.step();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Really Quit?", "Quit Confirmation", 0, 3);
                switch (n) {
                    case 0: {
                        VMFrame.this.removeInstance();
                    }
                }
            }
        });
        this.autoGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMFrame.this.autoGenerateString();
            }
        });
        this.selfGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VMFrame.this.selfGenerateString();
            }
        });
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.virtMemPanel = new VirtualMemoryPanel();
        this.physMemPanel = new PhysicalMemoryPanel();
        this.memPanel = new JPanel();
        this.tlbPanel = new TLBPanel();
        this.pageTablePanel = new PageTablePanel();
        this.bottomPanel = new JPanel();
        this.bottomScrollPane = new JScrollPane(this.bottomPanel);
        this.pTables = new JPanel();
        this.pTLBHitsMisses = new JPanel();
        this.pPageHitsFaults = new JPanel();
        this.pAutoSelfGen = new JPanel();
        this.pAddRefStr = new JPanel();
        this.pEastPanel = new JPanel();
        this.pBits = new JPanel();
        this.pBitsInVM = new JPanel();
        this.pBitsInPM = new JPanel();
        this.memPanel.setLayout(new BorderLayout());
        this.memPanel.add((Component)this.physMemPanel, "Center");
        this.memPanel.add((Component)this.virtMemPanel, "South");
        this.memBorder = BorderFactory.createEtchedBorder();
        this.memPanel.setBorder(BorderFactory.createTitledBorder(this.memBorder, ""));
        this.bottomPanel.add(this.lProgress);
        this.bottomPanel.add(this.progressScroll);
        this.bottomPanel.add(this.restart);
        this.bottomPanel.add(this.next);
        this.bottomPanel.add(this.back);
        this.bottomPanel.add(this.quit);
        this.pTLBHitsMisses.add(this.lTLBHits);
        this.pTLBHitsMisses.add(this.tTLBHits);
        this.pTLBHitsMisses.add(this.lTLBMisses);
        this.pTLBHitsMisses.add(this.tTLBMisses);
        this.pPageHitsFaults.add(this.lPageHits);
        this.pPageHitsFaults.add(this.tPageHits);
        this.pPageHitsFaults.add(this.lPageFaults);
        this.pPageHitsFaults.add(this.tPageFaults);
        this.pTables.add(this.tlbPanel);
        this.pTables.add(this.pTLBHitsMisses);
        this.pTables.add(this.pageTablePanel);
        this.pTables.add(this.pPageHitsFaults);
        this.tablesBorder = BorderFactory.createEtchedBorder();
        this.pTables.setBorder(BorderFactory.createTitledBorder(this.tablesBorder, ""));
        this.pAutoSelfGen.setLayout(new GridLayout(2, 1));
        this.pAutoSelfGen.add(this.autoGen);
        this.pAutoSelfGen.add(this.selfGen);
        this.pAddRefStr.setLayout(new BorderLayout());
        this.pAddRefStr.setPreferredSize(new Dimension(120, 200));
        this.pAddRefStr.add((Component)this.addRefStrScroll, "Center");
        this.pAddRefStr.add((Component)this.pAutoSelfGen, "South");
        this.addRefStrBorder = BorderFactory.createEtchedBorder();
        this.pAddRefStr.setBorder(BorderFactory.createTitledBorder(this.addRefStrBorder, " Address Reference String "));
        this.pBitsInVM.setLayout(new BorderLayout());
        this.bitsInVMBorder = BorderFactory.createEtchedBorder();
        this.pBitsInVM.setBorder(BorderFactory.createTitledBorder(this.bitsInVMBorder, " Virtual Address Bits "));
        this.pBitsInVM.add((Component)this.tPageInVM, "West");
        this.pBitsInVM.add((Component)this.tOffsetInVM, "Center");
        this.pBitsInVM.add((Component)this.lBitsInVM, "South");
        this.pBitsInPM.setLayout(new BorderLayout());
        this.bitsInPMBorder = BorderFactory.createEtchedBorder();
        this.pBitsInPM.setBorder(BorderFactory.createTitledBorder(this.bitsInPMBorder, " Physical Address Bits "));
        this.pBitsInPM.add((Component)this.tPageInPM, "West");
        this.pBitsInPM.add((Component)this.tOffsetInPM, "Center");
        this.pBitsInPM.add((Component)this.lBitsInPM, "South");
        this.pBits.setLayout(new GridLayout(2, 1));
        this.bitsBorder = BorderFactory.createEtchedBorder();
        this.pBits.setBorder(BorderFactory.createTitledBorder(this.bitsBorder, ""));
        this.pBits.add(this.pBitsInVM);
        this.pBits.add(this.pBitsInPM);
        this.pEastPanel.setLayout(new BorderLayout());
        this.pEastPanel.setPreferredSize(new Dimension(210, 600));
        this.pEastPanel.add((Component)this.pAddRefStr, "Center");
        this.pEastPanel.add((Component)this.pBits, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.memPanel, "West");
        container.add((Component)this.pTables, "Center");
        container.add((Component)this.pEastPanel, "East");
        container.add((Component)this.bottomScrollPane, "South");
        for (int i = 0; i < 4; ++i) {
            this.statusFrameEmpty[i] = true;
            this.statusFrameLRU[i] = 0;
            this.statusTLBRowEmpty[i] = true;
            this.statusTLBRowLRU[i] = 0;
        }
        this.statusMemFrameLRU = 0;
        this.statusRowLRU = 0;
        this.createAddresses();
        this.pack();
    }

    public void reStart() {
        int n;
        for (n = 0; n < 32; ++n) {
            this.physMemPanel.boolWords[n] = false;
        }
        for (n = 0; n < 4; ++n) {
            this.physMemPanel.boolFrames[n] = false;
            this.statusFrameEmpty[n] = true;
            this.statusFrameLRU[n] = 0;
            this.tlbPanel.boolRows[n] = false;
            this.statusTLBRowEmpty[n] = true;
            this.statusTLBRowLRU[n] = 0;
            this.tlbPanel.virtPageNum[n] = "-";
            this.tlbPanel.physPageNum[n] = "-";
            for (int i = 0; i < 32; ++i) {
                this.physMemPanel.stringWords[n][i] = "";
            }
        }
        for (n = 0; n < 8; ++n) {
            this.virtMemPanel.boolPages[n] = false;
            this.pageTablePanel.boolRows[n] = false;
            this.pageTablePanel.frameNum[n] = "-";
            this.pageTablePanel.validBit[n] = "0";
        }
        this.tlbHits = 0;
        this.tlbMisses = 0;
        this.tTLBHits.setText("  0");
        this.tTLBMisses.setText("  0");
        this.pageHits = 0;
        this.pageFaults = 0;
        this.tPageHits.setText("  0");
        this.tPageFaults.setText("  0");
        this.boolTLBHit = false;
        this.boolPageHit = false;
        this.tlbEntry = -1;
        this.pageTableEntry = -1;
        this.emptyMemFrame = -1;
        this.lruMemFrame = -1;
        this.frameNum = -1;
        this.statusMemFrameLRU = 0;
        this.emptyTLBRow = -1;
        this.tlbRow = -1;
        this.statusRowLRU = 0;
        this.listData.removeAllElements();
        this.addRefStrList.setListData(this.listData);
        this.tPageInVM.setText("");
        this.tPageInPM.setText("");
        this.tOffsetInVM.setText("");
        this.tOffsetInPM.setText("");
        this.tPageInVM.setBackground(new Color(205, 205, 205));
        this.tPageInPM.setBackground(new Color(205, 205, 205));
        this.tOffsetInVM.setBackground(new Color(205, 205, 205));
        this.tOffsetInPM.setBackground(new Color(205, 205, 205));
        this.tProgress.setText("Let's start over.\nPlease generate the Address Reference String.\nThen click on \"Next\" to continue.");
        this.next.setEnabled(false);
        this.back.setEnabled(false);
        this.autoGen.setEnabled(true);
        this.selfGen.setEnabled(true);
        this.moveStatus = 0;
        this.evaluateIndex = 0;
        this.reStarted = true;
        this.repaint();
    }

    public void step() {
        int n;
        int n2;
        for (n2 = 0; n2 < 32; ++n2) {
            this.physMemPanel.boolWords[n2] = false;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.physMemPanel.boolFrames[n2] = false;
            this.statusFrameEmpty[n2] = true;
            this.statusFrameLRU[n2] = 0;
            this.tlbPanel.boolRows[n2] = false;
            this.statusTLBRowEmpty[n2] = true;
            this.statusTLBRowLRU[n2] = 0;
            this.tlbPanel.virtPageNum[n2] = "-";
            this.tlbPanel.physPageNum[n2] = "-";
            for (n = 0; n < 32; ++n) {
                this.physMemPanel.stringWords[n2][n] = "";
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            this.virtMemPanel.boolPages[n2] = false;
            this.pageTablePanel.boolRows[n2] = false;
            this.pageTablePanel.frameNum[n2] = "-";
            this.pageTablePanel.validBit[n2] = "0";
        }
        this.tlbHits = 0;
        this.tlbMisses = 0;
        this.tTLBHits.setText("  0");
        this.tTLBMisses.setText("  0");
        this.pageHits = 0;
        this.pageFaults = 0;
        this.tPageHits.setText("  0");
        this.tPageFaults.setText("  0");
        this.boolTLBHit = false;
        this.boolPageHit = false;
        this.tlbEntry = -1;
        this.pageTableEntry = -1;
        this.emptyMemFrame = -1;
        this.lruMemFrame = -1;
        this.frameNum = -1;
        this.statusMemFrameLRU = 0;
        this.emptyTLBRow = -1;
        this.tlbRow = -1;
        this.statusRowLRU = 0;
        this.tPageInVM.setText("");
        this.tPageInPM.setText("");
        this.tOffsetInVM.setText("");
        this.tOffsetInPM.setText("");
        this.tPageInVM.setBackground(new Color(205, 205, 205));
        this.tPageInPM.setBackground(new Color(205, 205, 205));
        this.tOffsetInVM.setBackground(new Color(205, 205, 205));
        this.tOffsetInPM.setBackground(new Color(205, 205, 205));
        this.autoGen.setEnabled(false);
        this.selfGen.setEnabled(false);
        this.evaluateIndex = 0;
        if (this.nextClicked) {
            ++this.moveStatus;
        } else {
            --this.moveStatus;
            this.next.setEnabled(true);
        }
        if (this.moveStatus == 0) {
            this.back.setEnabled(false);
            this.tProgress.setText("You cannot go back any further.\nPlease click on \"Next\" or \"Restart\" to continue.");
            this.tProgress.setCaretPosition(0);
            this.addRefStrList.clearSelection();
        } else {
            this.back.setEnabled(true);
        }
        block13: for (n2 = 1; n2 <= this.moveStatus; ++n2) {
            switch (n2 % 7) {
                case 1: {
                    int n3;
                    this.addRefStrList.setSelectedIndex(this.evaluateIndex);
                    if (n2 == this.moveStatus) {
                        this.addRefStrList.ensureIndexIsVisible(this.evaluateIndex);
                    }
                    this.hexAddress = (String)this.addRefStrList.getSelectedValue();
                    n = Integer.parseInt(this.hexAddress, 16);
                    this.binAddressVM = Integer.toBinaryString(n);
                    if (this.binAddressVM.length() < 8) {
                        n3 = 8 - this.binAddressVM.length();
                        for (int i = 0; i < n3; ++i) {
                            this.binAddressVM = '0' + this.binAddressVM;
                        }
                    }
                    this.virtPage = this.binAddressVM.substring(0, 3);
                    this.offset = this.binAddressVM.substring(3);
                    this.intVirtPageDec = Integer.parseInt(this.virtPage, 2);
                    this.intOffsetDec = Integer.parseInt(this.offset, 2);
                    if (n2 != this.moveStatus) continue block13;
                    this.tProgress.setText("The virtual memory address we want is obtained from the Address Reference String. It is (in hexadecimal): " + this.hexAddress + ".");
                    this.tProgress.setCaretPosition(0);
                    continue block13;
                }
                case 2: {
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("The hexadecimal address " + this.hexAddress + " evaluates to its binary equivalent " + this.binAddressVM + ".\nHence the bits in the Virtual Address are divided into the following fields\n" + this.virtPage + " --> Page,  " + this.offset + " --> Offset.\nThe above field values are used to access the required virtual page from the virtual memory space.");
                        this.tProgress.setCaretPosition(0);
                        this.tPageInVM.setBackground(Color.green);
                        this.tOffsetInVM.setBackground(Color.green);
                    }
                    this.tPageInVM.setText("  " + this.virtPage);
                    this.tOffsetInVM.setText("     " + this.offset);
                    continue block13;
                }
                case 3: {
                    int n3;
                    this.tPageInVM.setBackground(new Color(205, 205, 205));
                    this.tOffsetInVM.setBackground(new Color(205, 205, 205));
                    this.tlbEntry = -1;
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("The bits in the Virtual Address indicating the virtual page are " + this.virtPage + ".\nThe equivalent virtual page number in decimal, then, is " + this.intVirtPageDec + " so, the Translation Lookaside Buffer, TLB, is searched for this page number.");
                        this.tProgress.setCaretPosition(0);
                    }
                    for (n3 = 0; n3 < 4; ++n3) {
                        if (!this.tlbPanel.virtPageNum[n3].equals("" + this.intVirtPageDec)) continue;
                        this.tlbEntry = n3;
                        break;
                    }
                    if (this.tlbEntry >= 0) {
                        this.boolTLBHit = true;
                        this.physPage = Integer.toBinaryString(Integer.parseInt(this.tlbPanel.physPageNum[this.tlbEntry], 10));
                        if (this.physPage.length() == 1) {
                            this.physPage = '0' + this.physPage;
                        }
                        this.binAddressPM = this.physPage + this.offset;
                        this.physAddress = Integer.parseInt(this.binAddressPM, 2);
                        if (n2 == this.moveStatus) {
                            this.tProgress.append("\nThere was a TLB hit since a matching entry was found in the TLB for the virtual page number " + this.intVirtPageDec + ".\nThe physical page frame number is retrieved from this entry. It is " + this.tlbPanel.physPageNum[this.tlbEntry] + ".\nThus, the physical address bits are " + this.binAddressPM + ".\nThe actual physical address is, therefore, " + this.physAddress);
                            this.tProgress.setCaretPosition(0);
                            this.tPageInPM.setBackground(Color.green);
                            this.tOffsetInPM.setBackground(Color.green);
                        }
                        this.tPageInPM.setText("   " + this.physPage);
                        this.tOffsetInPM.setText("     " + this.offset);
                        this.tlbPanel.boolRows[this.tlbEntry] = true;
                        this.statusTLBRowLRU[this.tlbEntry] = ++this.statusRowLRU;
                        ++this.tlbHits;
                        this.tTLBHits.setText("  " + this.tlbHits);
                        continue block13;
                    }
                    this.boolTLBHit = false;
                    if (n2 == this.moveStatus) {
                        this.tProgress.append("\nSince a matching entry was not found for the virtual page number, there was a TLB miss.\nNow the entry at row " + this.intVirtPageDec + " in the page table is looked up.");
                        this.tProgress.setCaretPosition(0);
                    }
                    ++this.tlbMisses;
                    this.tTLBMisses.setText("  " + this.tlbMisses);
                    this.pageTablePanel.boolRows[this.intVirtPageDec] = true;
                    if (this.pageTablePanel.validBit[this.intVirtPageDec].equals("1")) {
                        this.pageTableEntry = Integer.parseInt(this.pageTablePanel.frameNum[this.intVirtPageDec], 10);
                    }
                    if (this.pageTableEntry >= 0) {
                        this.boolPageHit = true;
                        this.physPage = Integer.toBinaryString(this.pageTableEntry);
                        if (this.physPage.length() == 1) {
                            this.physPage = '0' + this.physPage;
                        }
                        this.binAddressPM = this.physPage + this.offset;
                        this.physAddress = Integer.parseInt(this.binAddressPM, 2);
                        if (n2 == this.moveStatus) {
                            this.tProgress.append("\nSince the virtual page number had a valid entry in the page table, there was a page hit.\nThe physical page number is " + this.pageTableEntry + ".\nThus, the physical address bits are " + this.binAddressPM + ".\nThe actual physical address is, therefore, " + this.physAddress + ".\n\nNote that the TLB is now updated using the information found in the page table.");
                            this.tProgress.setCaretPosition(0);
                            this.tPageInPM.setBackground(Color.green);
                            this.tOffsetInPM.setBackground(Color.green);
                        }
                        this.tPageInPM.setText("   " + this.physPage);
                        this.tOffsetInPM.setText("     " + this.offset);
                        ++this.pageHits;
                        this.tPageHits.setText("  " + this.pageHits);
                        this.emptyTLBRow = this.getFirstEmptyTLBRow();
                        if (this.emptyTLBRow != -1) {
                            this.tlbPanel.virtPageNum[this.emptyTLBRow] = "" + this.intVirtPageDec;
                            this.tlbPanel.physPageNum[this.emptyTLBRow] = "" + this.pageTableEntry;
                            this.statusTLBRowEmpty[this.emptyTLBRow] = false;
                            this.statusTLBRowLRU[this.emptyTLBRow] = ++this.statusRowLRU;
                            this.tlbEntry = this.emptyTLBRow;
                            continue block13;
                        }
                        this.tlbPanel.virtPageNum[this.getLRURow()] = "" + this.intVirtPageDec;
                        this.tlbPanel.physPageNum[this.getLRURow()] = "" + this.pageTableEntry;
                        this.statusTLBRowLRU[this.getLRURow()] = ++this.statusRowLRU;
                        this.tlbEntry = this.getLRURow();
                        continue block13;
                    }
                    this.boolPageHit = false;
                    if (n2 == this.moveStatus) {
                        this.tProgress.append("\nSince the page table entry for this virtual page number had a valid bit of 0, there was a page fault.\nThe page must now be brought into physical memory from the hard disk.");
                        this.tProgress.setCaretPosition(0);
                    }
                    ++this.pageFaults;
                    this.tPageFaults.setText("  " + this.pageFaults);
                    continue block13;
                }
                case 4: {
                    if (this.tlbEntry >= 0) {
                        this.tlbPanel.boolRows[this.tlbEntry] = false;
                    }
                    this.pageTablePanel.boolRows[this.intVirtPageDec] = false;
                    this.tPageInPM.setBackground(new Color(205, 205, 205));
                    this.tOffsetInPM.setBackground(new Color(205, 205, 205));
                    if (this.boolTLBHit) {
                        this.frameNum = Integer.parseInt(this.tlbPanel.physPageNum[this.tlbEntry], 10);
                        this.physMemPanel.boolFrames[this.frameNum] = true;
                        this.physMemPanel.boolWords[this.intOffsetDec] = true;
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("As we saw in the previous step, the page frame number was retrieved from the TLB.Highlighted is the page frame in physical memory with the data that we wanted.Since the offset retrieved from the virtual address was " + this.intOffsetDec + ", the word at this offset from the first address in the frame is the required data word.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.statusFrameLRU[Integer.parseInt((String)this.tlbPanel.physPageNum[this.tlbEntry], (int)10)] = ++this.statusMemFrameLRU;
                        continue block13;
                    }
                    if (this.pageTablePanel.validBit[this.intVirtPageDec].equals("1")) {
                        this.frameNum = this.pageTableEntry;
                        this.physMemPanel.boolFrames[this.frameNum] = true;
                        this.physMemPanel.boolWords[this.intOffsetDec] = true;
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("As we saw in the previous step, the page frame number was retrieved from the Page Table.\nHighlighted is the page frame in physical memory with the data that we wanted.\nSince the offset retrieved from the virtual address was " + this.intOffsetDec + ", the word at this offset from the first address in the frame is the required data word.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.statusFrameLRU[this.pageTableEntry] = ++this.statusMemFrameLRU;
                        continue block13;
                    }
                    this.emptyMemFrame = this.getFirstEmptyMemFrame();
                    if (this.emptyMemFrame != -1) {
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("Since the memory has empty space, the first available frame will be filled.\nHighlighted is the memory frame into which the page will be brought.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.physMemPanel.boolFrames[this.emptyMemFrame] = true;
                        this.frameNum = this.emptyMemFrame;
                        continue block13;
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("Since the memory is full, the least recently used memory frame will be replaced.\nHighlighted is the victim memory frame which will be replaced.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.lruMemFrame = this.getLRUMemFrame();
                    this.physMemPanel.boolFrames[this.lruMemFrame] = true;
                    this.frameNum = this.lruMemFrame;
                    continue block13;
                }
                case 5: {
                    if (this.frameNum >= 0) {
                        this.physMemPanel.boolFrames[this.frameNum] = false;
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("Highlighted is the virtual page we need.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.virtMemPanel.boolPages[this.intVirtPageDec] = true;
                    continue block13;
                }
                case 6: {
                    int n3;
                    this.virtMemPanel.boolPages[this.intVirtPageDec] = false;
                    if (this.boolTLBHit || this.boolPageHit) {
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("As we saw earlier, the page already exists in frame " + this.frameNum + ".\nHighlighted in black is the required word at offset " + this.intOffsetDec + ".");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.physMemPanel.boolFrames[this.frameNum] = true;
                        this.physMemPanel.boolWords[this.intOffsetDec] = true;
                        continue block13;
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("The page is brought in from disk to memory into frame " + this.frameNum + ".\nHighlighted in black is the required word at offset " + this.intOffsetDec + ".");
                        this.tProgress.setCaretPosition(0);
                    }
                    if (this.lruMemFrame >= 0) {
                        String string = this.physMemPanel.stringWords[this.lruMemFrame][0].substring(1, 2);
                        this.pageTablePanel.frameNum[Integer.parseInt((String)string)] = "-";
                        this.pageTablePanel.validBit[Integer.parseInt((String)string)] = "0";
                        if (n2 == this.moveStatus) {
                            this.tProgress.append("\nNote that, since the previous page " + string + " that was in the frame was replaced, the corresponding entry in the page table is invalidated.");
                            this.tProgress.setCaretPosition(0);
                        }
                    }
                    this.physMemPanel.boolFrames[this.frameNum] = true;
                    this.physMemPanel.boolWords[this.intOffsetDec] = true;
                    for (n3 = 0; n3 < 32; ++n3) {
                        this.physMemPanel.stringWords[this.frameNum][n3] = "P" + this.intVirtPageDec + "Of" + n3;
                    }
                    this.statusFrameEmpty[this.frameNum] = false;
                    this.statusFrameLRU[this.frameNum] = ++this.statusMemFrameLRU;
                    this.emptyTLBRow = this.getFirstEmptyTLBRow();
                    if (this.emptyTLBRow != -1) {
                        this.tlbPanel.virtPageNum[this.emptyTLBRow] = "" + this.intVirtPageDec;
                        this.tlbPanel.physPageNum[this.emptyTLBRow] = "" + this.frameNum;
                        this.tlbPanel.boolRows[this.emptyTLBRow] = true;
                        this.statusTLBRowEmpty[this.emptyTLBRow] = false;
                        this.statusTLBRowLRU[this.emptyTLBRow] = ++this.statusRowLRU;
                        this.tlbEntry = this.emptyTLBRow;
                    } else {
                        this.tlbPanel.virtPageNum[this.getLRURow()] = "" + this.intVirtPageDec;
                        this.tlbPanel.physPageNum[this.getLRURow()] = "" + this.frameNum;
                        this.tlbPanel.boolRows[this.getLRURow()] = true;
                        this.tlbEntry = this.getLRURow();
                        this.statusTLBRowLRU[this.getLRURow()] = ++this.statusRowLRU;
                    }
                    this.pageTablePanel.frameNum[this.intVirtPageDec] = "" + this.frameNum;
                    this.pageTablePanel.validBit[this.intVirtPageDec] = "1";
                    this.pageTablePanel.boolRows[this.intVirtPageDec] = true;
                    this.physPage = Integer.toBinaryString(this.frameNum);
                    if (this.physPage.length() == 1) {
                        this.physPage = '0' + this.physPage;
                    }
                    this.binAddressPM = this.physPage + this.offset;
                    this.physAddress = Integer.parseInt(this.binAddressPM, 2);
                    if (n2 == this.moveStatus) {
                        this.tProgress.append("\nNote that the physical address was generated as the page was brought into memory.\nLet's clearly understand the evaluation of the physical address:\nThe physical page frame number is " + this.frameNum + ".\nThus, the page bits in the physical address bits are " + this.physPage + ".\nThe word bits are the same as in the virtual address, " + this.offset + ".\nThe actual physical address in decimal is, therefore, " + this.physAddress + ".");
                        this.tProgress.setCaretPosition(0);
                        this.tPageInPM.setBackground(Color.green);
                        this.tOffsetInPM.setBackground(Color.green);
                    }
                    this.tPageInPM.setText("   " + this.physPage);
                    this.tOffsetInPM.setText("     " + this.offset);
                    continue block13;
                }
                case 0: {
                    if (this.frameNum >= 0) {
                        this.physMemPanel.boolFrames[this.frameNum] = false;
                    }
                    this.physMemPanel.boolWords[this.intOffsetDec] = false;
                    if (this.tlbEntry >= 0) {
                        this.tlbPanel.boolRows[this.tlbEntry] = false;
                    }
                    this.pageTablePanel.boolRows[this.intVirtPageDec] = false;
                    this.tPageInPM.setBackground(new Color(205, 205, 205));
                    this.tOffsetInPM.setBackground(new Color(205, 205, 205));
                    this.tPageInVM.setText("");
                    this.tOffsetInVM.setText("");
                    this.tPageInPM.setText("");
                    this.tOffsetInPM.setText("");
                    this.tPageInVM.setBackground(new Color(205, 205, 205));
                    this.tOffsetInVM.setBackground(new Color(205, 205, 205));
                    this.tPageInPM.setBackground(new Color(205, 205, 205));
                    this.tOffsetInPM.setBackground(new Color(205, 205, 205));
                    this.addRefStrList.clearSelection();
                    ++this.evaluateIndex;
                    if (this.evaluateIndex == this.listData.size()) {
                        if (n2 == this.moveStatus) {
                            this.tProgress.setText("This completes the runthrough.\nPlease click on \"Restart\", generate the Address Reference String OR click \"Quit\" to finish.");
                            this.tProgress.setCaretPosition(0);
                        }
                        this.next.setEnabled(false);
                        this.autoGen.setEnabled(true);
                        this.selfGen.setEnabled(true);
                        this.reStarted = false;
                        continue block13;
                    }
                    if (n2 == this.moveStatus) {
                        this.tProgress.setText("This completes an access cycle.");
                        this.tProgress.setCaretPosition(0);
                    }
                    this.addRefStrList.clearSelection();
                    continue block13;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Uh Oh! There something wrong in switch-case!");
                }
            }
        }
        this.repaint();
    }

    public void autoGenerateString() {
        for (int i = 0; i < 10; ++i) {
            int n = (int)(Math.random() * 256.0);
            this.listData.add(this.addresses[n]);
        }
        this.addRefStrList.setListData(this.listData);
        this.evaluateIndex = 0;
        this.next.setEnabled(true);
        this.back.setEnabled(false);
        this.tProgress.setText("We have automatically generated an address string of 10 addresses for you to work with.\nPlease click on \"Next\" to continue.");
    }

    public void selfGenerateString() {
        int n = 0;
        int n2 = 0;
        JTextField jTextField = new JTextField();
        Object[] objectArray2 = new Object[]{"Continue", "Done"};
        while (n == 0 && n2 < 10) {
            JOptionPane painPeko = new JOptionPane("Enter address string:", -1, -1, null, objectArray2, objectArray2[0]);
            painPeko.setWantsInput(true);
            painPeko.createDialog(this, "Self Generate Address").setVisible(true);
            Object sel = painPeko.getValue();
            jTextField.setText((String)painPeko.getInputValue());
            int n3 = sel == null ? -1 : (n = sel.equals(objectArray2[0]) ? 0 : 1);
            if (n == 0) {
                if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                    this.listData.add(jTextField.getText().toUpperCase());
                    ++n2;
                } else {
                    JOptionPane.showMessageDialog(this, "Invalid Input. Please try again.", "Invalid Input", 0);
                }
                jTextField.setText("");
                continue;
            }
            if (n != 1 || jTextField.getText().equals("")) continue;
            if (this.validateInput(jTextField.getText()) || this.validateInput(jTextField.getText().toUpperCase())) {
                this.listData.add(jTextField.getText().toUpperCase());
                this.tProgress.setText("You have generated an Address Reference String of " + ++n2 + " address.\nPlease click on \"Next\" to continue.");
                this.tProgress.setCaretPosition(0);
                continue;
            }
            JOptionPane.showMessageDialog(this, "Invalid Input. Quitting without saving last entry.", "Invalid Input", 0);
            this.tProgress.setText("You have generated an Address Reference String of " + n2 + " address.\nPlease click on \"Next\" to continue.");
            this.tProgress.setCaretPosition(0);
        }
        this.addRefStrList.setListData(this.listData);
        this.evaluateIndex = 0;
        if (n2 > 0) {
            this.next.setEnabled(true);
            this.back.setEnabled(false);
        }
    }

    public boolean validateInput(String string) {
        for (int i = 0; i < 256; ++i) {
            if (!this.addresses[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void createAddresses() {
        int n = -1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.addresses[++n] = this.tempAddress[i] + this.tempAddress[j];
            }
        }
    }

    public int getFirstEmptyMemFrame() {
        for (int i = 0; i < 4; ++i) {
            if (!this.statusFrameEmpty[i]) continue;
            return i;
        }
        return -1;
    }

    public int getLRUMemFrame() {
        int n = 0;
        for (int i = 1; i < 4; ++i) {
            if (this.statusFrameLRU[n] <= this.statusFrameLRU[i]) continue;
            n = i;
        }
        return n;
    }

    public int getFirstEmptyTLBRow() {
        for (int i = 0; i < 4; ++i) {
            if (!this.statusTLBRowEmpty[i]) continue;
            return i;
        }
        return -1;
    }

    public int getLRURow() {
        int n = 0;
        for (int i = 1; i < 4; ++i) {
            if (this.statusTLBRowLRU[n] <= this.statusTLBRowLRU[i]) continue;
            n = i;
        }
        return n;
    }

    public void removeInstance() {
        this.dispose();
    }
}

