/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

class VirtualMemoryPanel
extends JPanel {
    boolean[] boolPages = new boolean[8];
    private Dimension dV;
    private int dx;
    private int dy;
    private int offsetX;
    private int offsetY;

    public VirtualMemoryPanel() {
        this.setPreferredSize(new Dimension(395, 200));
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createTitledBorder(border, " Virtual Memory "));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        this.dV = this.getSize();
        this.dV.height -= 20;
        this.dV.width -= 20;
        this.dy = this.dV.height / 8;
        int n2 = this.dy * 8;
        this.offsetY = 14;
        this.offsetX = this.dV.width / 2 - 40;
        graphics.setColor(Color.black);
        for (n = 0; n < 9; ++n) {
            graphics.drawLine(this.offsetX, this.offsetY + this.dy * n, this.offsetX + 80, this.offsetY + this.dy * n);
        }
        for (n = 0; n < 8; ++n) {
            graphics.drawString("Page " + n, this.offsetX + 20, this.offsetY + this.dy * n + 18);
        }
        graphics.drawLine(this.offsetX, this.offsetY, this.offsetX, this.offsetY + n2);
        graphics.drawLine(this.offsetX + 80, this.offsetY, this.offsetX + 80, this.offsetY + n2);
        for (n = 0; n < 8; ++n) {
            if (!this.boolPages[n]) continue;
            graphics.setColor(Color.yellow);
            graphics.fillRect(this.offsetX + 1, this.offsetY + 1 + this.dy * n, 79, this.dy - 1);
            graphics.setColor(Color.black);
            graphics.drawString("Page " + n, this.offsetX + 20, this.offsetY + this.dy * n + 18);
        }
    }
}

